/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.ITradeStrategyHintContext;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.SetType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class CentralStorageHintContext
implements ITradeStrategyHintContext {
    @ListType(value=INavigableVessel.class)
    private List<INavigableVessel> supplyingVessels = new ArrayList<INavigableVessel>();
    @ListType(value=INavigableVessel.class)
    private List<INavigableVessel> distributingVessels = new ArrayList<INavigableVessel>();
    @SetType(value=IWare.class)
    private Set<IWare> wares = new HashSet<IWare>();
    @ListType(value=ICity.class)
    private List<ICity> suppliedCities = new ArrayList<ICity>();

    public void addWare(IWare ware) {
        this.wares.add(ware);
    }

    public void addSupplyingVessel(INavigableVessel vessel) {
        this.supplyingVessels.add(vessel);
    }

    public void addDistributingVessel(INavigableVessel vessel) {
        this.distributingVessels.add(vessel);
    }

    public void addSuppliedCity(ICity city) {
        this.suppliedCities.add(city);
    }

    public List<INavigableVessel> getSupplyingVessels() {
        return this.supplyingVessels;
    }

    public List<INavigableVessel> getDistributingVessels() {
        return this.distributingVessels;
    }

    public Set<IWare> getWares() {
        return this.wares;
    }

    public List<ICity> getSuppliedCities() {
        return this.suppliedCities;
    }
}

