/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.engine.player.CollectWaresMissionData;
import ch.sahits.game.openpatrician.engine.player.strategy.BasePlayerTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesDumpTradeStep;
import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.event.data.ai.SpecialMissionFinishedEvent;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public abstract class CollectionWaresStrategy
extends BasePlayerTradeStrategy {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private TradeService tradeService;
    @Autowired
    private SeafaringService seafaringService;
    @Autowired
    private ShipService shipService;
    @Autowired
    private MapService mapService;

    public CollectionWaresStrategy() {
        this.tradeStrategyType = EAITradeStrategyType.COLLECT_WARES;
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void destroy() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void initializeTradeCycle(IAIPlayer player, INavigableVessel vessel) {
        CollectWaresMissionData missionData = this.createMissionData(player);
        player.setTradeMission(vessel, (ITradeMissionData)missionData);
        ArrayList<IWare> requiredWares = new ArrayList<IWare>(missionData.getRequiredWareAmounts().keySet());
        Optional currentCity = this.shipService.findCity(vessel);
        HashSet<ICity> excludeCities = new HashSet<ICity>();
        currentCity.ifPresent(excludeCities::add);
        ICity firstStop = this.findDestinationToBuyRequiredProductionWares(player, requiredWares, vessel, excludeCities);
        IAITradeStrategyType strategyType = this.getStrategyType();
        player.setTradeStrategyType(vessel, strategyType);
        this.logger.debug("Reroute vessel " + vessel.getName() + " to " + firstStop.getName() + " current location: " + vessel.getLocation());
        if (player.hasMoreTradeSteps(vessel)) {
            this.logger.debug("There are tradesteps for vessel " + vessel.getName() + " that may cause problems");
        }
        this.seafaringService.travelToCity(vessel, firstStop);
    }

    protected abstract CollectWaresMissionData createMissionData(IAIPlayer var1);

    protected abstract IAITradeStrategyType getStrategyType();

    public void handleShipArrivesInPort(IShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        if (this.isMatchingTradeStrategy(vessel)) {
            ICity city = event.getCity();
            IAIPlayer player = (IAIPlayer)vessel.getOwner();
            CollectWaresMissionData tradeMission = (CollectWaresMissionData)player.getTradeMission(vessel);
            ICity destination = tradeMission.getCity();
            boolean haveEverything = false;
            Map<IWare, Integer> requiredWareAmounts = tradeMission.getRequiredWareAmounts();
            if (city.equals(destination)) {
                Optional optOffice = player.findTradingOffice(city);
                haveEverything = this.checkAllWaresCollected(city, vessel, tradeMission, optOffice);
                if (optOffice.isPresent()) {
                    ITradingOffice tradingOffice = (ITradingOffice)optOffice.get();
                    this.tradeService.transferFromVesselToStorage(vessel, (IPlayer)player, city, requiredWareAmounts);
                    for (IWare ware : requiredWareAmounts.keySet()) {
                        int amountStored = tradingOffice.getWare(ware).getAmount();
                        if (amountStored > requiredWareAmounts.get(ware)) {
                            requiredWareAmounts.put(ware, 0);
                            continue;
                        }
                        int newRequiredAmount = requiredWareAmounts.get(ware) - amountStored;
                        requiredWareAmounts.put(ware, newRequiredAmount);
                    }
                }
                if (haveEverything) {
                    List<IWare> loadedWares = this.getLoadedWares(vessel);
                    loadedWares.removeAll(requiredWareAmounts.keySet());
                    AggregatesDumpTradeStep dumpStep = this.createAggregatedDumpStep(vessel, city, loadedWares);
                    dumpStep.execute();
                    SpecialMissionFinishedEvent newEvent = new SpecialMissionFinishedEvent(vessel, city, (ITradeMissionData)tradeMission);
                    player.setTradeMission(vessel, null);
                    this.clientServerEventBus.post((Object)newEvent);
                }
            }
            if (!haveEverything) {
                List<IWare> requiredWares = this.getRequiredWares(vessel, requiredWareAmounts);
                AggregatedBuyTradeStep buyStep = this.createAggregatedBuyTradeStep(vessel, city, requiredWares);
                buyStep.execute();
                requiredWares = this.getRequiredWares(vessel, requiredWareAmounts);
                ICity nextStop = destination;
                if (!requiredWares.isEmpty()) {
                    HashSet<ICity> excludeCities = new HashSet<ICity>();
                    excludeCities.add(city);
                    nextStop = this.findDestinationToBuyRequiredProductionWares(player, requiredWares, vessel, excludeCities);
                }
                if (nextStop == null) {
                    nextStop = destination;
                }
                if (nextStop.equals(city)) {
                    nextStop = this.mapService.findNearestCityExclusive(city.getCoordinates());
                }
                this.addDefaultTradeSteps(vessel, player, city, nextStop, requiredWareAmounts.keySet(), new HashSet<IWare>(requiredWareAmounts.keySet()), true);
                this.executeTradeSteps(player, vessel);
            }
        }
    }

    private List<IWare> getRequiredWares(INavigableVessel vessel, Map<IWare, Integer> requiredWareAmounts) {
        ArrayList<IWare> requiredWares = new ArrayList<IWare>(requiredWareAmounts.keySet());
        Iterator iterator = requiredWares.iterator();
        while (iterator.hasNext()) {
            IWare ware = (IWare)iterator.next();
            int loadedAmount = vessel.getWare(ware).getAmount();
            if (loadedAmount < requiredWareAmounts.get(ware)) continue;
            iterator.remove();
        }
        return requiredWares;
    }

    protected abstract boolean checkAllWaresCollected(ICity var1, INavigableVessel var2, CollectWaresMissionData var3, Optional<ITradingOffice> var4);
}

