/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.sea.DangerService;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivity;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivityEntry;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.player.IAIHireSailorStrategy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.List;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class DefaultHireSailorsStrategy
implements IAIHireSailorStrategy {
    @Autowired
    private DangerService dangerService;
    @Autowired
    private PirateActivity pirateActivity;
    @Autowired
    private Random rnd;

    public int calculateRequiredSailorAmount(IShip ship, IAIPlayer player) {
        int nbAttacks;
        int min = ship.getMinNumberOfSailors();
        int max = ship.getMaxNumberOfSailors();
        int range = max - min;
        List<PirateActivityEntry> activity = this.pirateActivity.getPirateActivity();
        int observationDuration = this.pirateActivity.getObservationPeriodInDays();
        double twoWeeks = (double)observationDuration / 14.0;
        double attacksInTwoWeeks = twoWeeks / (double)(nbAttacks = this.dangerService.getNumberOfPirateAttacks(activity));
        if (attacksInTwoWeeks > 1.0) {
            return min;
        }
        if (attacksInTwoWeeks > 0.5) {
            return this.rnd.nextInt(range) + min;
        }
        return max;
    }
}

