/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategy;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class MoneyBasedEventDecisionStrategy
implements IAIEventDecisionStrategy {
    public boolean acceptMarriagBrokereOffer(IAIPlayer player) {
        if (!player.getSpouseData().isPresent()) {
            long cash = player.getCompany().getCash();
            return cash > 100000L;
        }
        return false;
    }

    public boolean acceptMarriageOffer(IAIPlayer player) {
        return this.acceptMarriagBrokereOffer(player);
    }

    public boolean shouldOrderCelebration(IAIPlayer player, ICity city) {
        long cash = player.getCompany().getCash();
        return cash > 100000L;
    }
}

