/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckedBuyTradeStep;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class AggregatedCheckedBuyTradeStep
implements ITradeStep {
    private INavigableVessel vessel;
    private ICity city;
    private boolean executeNext = true;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;
    @ListType(value=BuyTradeStep.class)
    private ArrayList<CheckedBuyTradeStep> tradeSteps = new ArrayList();

    public void addBuyStep(IWare ware, int maxPrice) {
        CheckedBuyTradeStep buyStep = (CheckedBuyTradeStep)this.context.getBean(CheckedBuyTradeStep.class);
        buyStep.setExecuteNext(this.executeNext);
        buyStep.setMaxBuyPrice(maxPrice);
        buyStep.setCity(this.city);
        buyStep.setVessel(this.vessel);
        buyStep.setWare(ware);
        this.tradeSteps.add(buyStep);
    }

    private List<CheckedBuyTradeStep> getPriorityList() {
        ArrayList<CheckedBuyTradeStep> list = new ArrayList<CheckedBuyTradeStep>();
        HashMap<CheckedBuyTradeStep, Integer> loadedWares = new HashMap<CheckedBuyTradeStep, Integer>();
        for (CheckedBuyTradeStep step : this.tradeSteps) {
            IWare ware = step.getWare();
            int amount = this.vessel.getWare(ware).getAmount();
            loadedWares.put(step, amount);
        }
        loadedWares.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> list.add((CheckedBuyTradeStep)entry.getKey()));
        return list;
    }

    public boolean execute() {
        Preconditions.checkArgument((boolean)this.vessel.getLocation().equals((Object)this.city.getCoordinates()), (Object)("The vessel " + this.vessel.getName() + " is not in city " + this.city.getName() + " but at " + this.vessel.getLocation()));
        List<CheckedBuyTradeStep> priorityList = this.getPriorityList();
        for (CheckedBuyTradeStep buyTradeStep : priorityList) {
            buyTradeStep.execute();
            if (this.vessel.getCapacity() != 0) continue;
            break;
        }
        return this.executeNext;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.tradeSteps.stream().forEach(step -> sb.append(step.getWare().name()).append(" "));
        return "AggregatedCheckedBuyTradeStep in " + this.city.getName() + " buying: " + sb.toString();
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setExecuteNext(boolean executeNext) {
        this.executeNext = executeNext;
    }
}

