/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.SellTradeStep;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class AggregatesSellTradeStep
implements ITradeStep {
    private INavigableVessel vessel;
    private ICity city;
    private boolean executeNext = true;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;
    @ListType(value=BuyTradeStep.class)
    private ArrayList<SellTradeStep> tradeSteps = new ArrayList();

    public void addSellStep(IWare ware) {
        SellTradeStep buyStep = (SellTradeStep)this.context.getBean(SellTradeStep.class);
        buyStep.setExecuteNext(this.executeNext);
        buyStep.setCity(this.city);
        buyStep.setVessel(this.vessel);
        buyStep.setWare(ware);
        this.tradeSteps.add(buyStep);
    }

    public boolean execute() {
        Preconditions.checkArgument((boolean)this.vessel.getLocation().equals((Object)this.city.getCoordinates()), (Object)("The vessel is not in city " + this.city.getName() + " but at " + this.vessel.getLocation()));
        for (SellTradeStep sellTradeStep : this.tradeSteps) {
            if (this.vessel.getWare(sellTradeStep.getWare()).getAmount() <= 0) continue;
            sellTradeStep.execute();
        }
        return this.executeNext;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.tradeSteps.stream().forEach(step -> sb.append(step.getWare().name()).append(" "));
        return "AggregatesSellTradeStep in " + this.city.getName() + " buying: " + sb.toString();
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setExecuteNext(boolean executeNext) {
        this.executeNext = executeNext;
    }
}

