/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.Optional;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class BuyWeaponTradeStep
implements ITradeStep {
    private ICity city;
    private IAIPlayer player;
    private INavigableVessel vessel;

    public boolean execute() {
        if (this.vessel instanceof IShip) {
            IAIBuyWeaponStrategy strategy = (IAIBuyWeaponStrategy)this.player.getWeaponBuyStrategyType().getStrategy();
            IShip ship = (IShip)this.vessel;
            Optional optBuyWeapons = strategy.shouldBuyWeapons(ship, this.player, this.city);
            optBuyWeapons.ifPresent(buyWeapons -> strategy.buyWeapons(buyWeapons, ship, this.player, this.city));
        }
        return true;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public ICity getCity() {
        return this.city;
    }

    public void setPlayer(IAIPlayer player) {
        this.player = player;
    }

    public IAIPlayer getPlayer() {
        return this.player;
    }

    public INavigableVessel getVessel() {
        return this.vessel;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }
}

