package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;

import java.time.LocalDateTime;

/**
 * Building task for the city wall.
 * This implementation does not yet take into account that there needs
 * to be a free building crew.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 05, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CityWallBuildingTask extends TimedTask {
    private final CityWall cityWall;

    public CityWallBuildingTask(CityWall cityWall, LocalDateTime exectutionTime) {
        this.cityWall = cityWall;
        setExecutionTime(exectutionTime);
    }

    @Override
    public void run() {
        cityWall.setUsedBricks(cityWall.getBoughtBricks()); // use all the bricks
    }

    @Override
    public String toString() {
        return "CityWallBuildingTask{" +
                "UUID=" + getUuid() +
                ", execution at " + getExecutionTime() +
                ", cityWall=" + cityWall +
                '}';
    }
}
