package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageHintContext;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * Trade mission data for the delivering of wares from a central storage.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 23, 2017
 */
@Getter
@Setter
@ClassCategory({EClassCategory.DEPENDS_ON_SERIALIZED_BEAN, EClassCategory.MODEL})
public class CentralStorageDeliverMissionData implements ITradeMissionData {

    private ICity sourceCity;

    private CentralStorageHintContext context;

    private LocalDateTime lastVisit;
}
