package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAIHireTradeManagerStrategy;
import ch.sahits.game.openpatrician.model.player.IAIHireTradeManagerStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 17, 2017
 */
public enum EHireTradeManagerStrategyType implements IAIHireTradeManagerStrategyType {
    /** Strategy based on the available and used storage capacity. */
    CAPACITY_BASED_HIRING_POLICY(HireDismissTradeManagerMinStorageCapacityStrategy.class),
    /** Stragegy based on wokshops, offices and common strategy. */
    TOWN_STRATEGY_BASED_HIRING(HireDismissTradeManagerStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAIHireTradeManagerStrategy> strategyClass;

    EHireTradeManagerStrategyType(Class<? extends IAIHireTradeManagerStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }
    public void setApplicationContext(org.springframework.context.ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAIHireTradeManagerStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
