package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.city.ICity;

/**
 * Interface for construction strategies that need to set the construction city from the outside.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 28, 2017
 */
public interface IAICityDependentShipConstructionStrategy {
    /**
     * Set the city where the construction of the new ship happens.
     * @param city in which the ship construction should happen.
     */
    void setConstructionCity(ICity city);
}
