package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Setter;

/**
 * This dump sell step is conditional based on the amount of loaded wares on the ship.
 * It is best used with a preceding sell step and then use this dump step to check if there
 * is too much wares loaded and to dump them.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 24, 2016
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class AmountBasedAggregatedDumpTradeStep extends AbstractAggregateDumpTradeStep {
    /**
     * Maximal amount that should be on the ship. If there
     * is more loaded everything is dumped.
     */
    @Setter
    private int maxAmount;

    @Override
    public boolean execute() {
        INavigableVessel vessel = getVessel();
        int loaded = vessel.getLoadBinding().get();
        if (loaded > maxAmount) {
            return super.execute();
        } else {
            return true;
        }
    }

}
