package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.engine.sea.model.PirateActivityEntry;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Service to calculate the current danger based on recent pirate attacks.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 17, 2017
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class DangerService {

    /**
     * Count the number of distinct pirates.
      * @return number of free sea pirates.
     */
    public int getNumberOfPirates(List<PirateActivityEntry> activities) {
        Map<ISeaPirate, Integer> counter = new HashMap<>();
        for (PirateActivityEntry activity : activities) {
            ISeaPirate pirate = activity.getPirate();
            if (counter.containsKey(pirate)) {
                counter.put(pirate, counter.get(pirate) + 1);
            } else {
                counter.put(pirate, 1);
            }
        }
        return counter.size();
    }

    /**
     * Retrieve the number of pirate attacks.
     * @return number of pirate attacks
     */
    public int getNumberOfPirateAttacks(List<PirateActivityEntry> activities) {
        return activities.size();
    }

    /**
     * Retrieve the number of pirate attacks where the victim suffered.
     * @return number of successful pirate attacks
     */
    public int getNumberOfSuccessfulPirateAttacks(List<PirateActivityEntry> activities) {
       return (int) activities.stream()
               .filter(PirateActivityEntry::isFightWon)
               .filter(attack -> attack.getEnteredShips() > 0 || attack.getLootedShips() > 0 || attack.getSukenShips() > 0)
               .count();
    }
}
