/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerTaskFactory;
import ch.sahits.game.openpatrician.engine.event.task.AIRefitTask;
import ch.sahits.game.openpatrician.engine.event.task.AIRepairTask;
import ch.sahits.game.openpatrician.engine.event.task.ChurchUpgradeTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.ClearCityEventTask;
import ch.sahits.game.openpatrician.engine.event.task.LoanerCollectMoneyAfterAuctionTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.LoanerCollectMoneyWithoutAuctionTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.MarriageOfferDeclinedTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.MarriageOfferTask;
import ch.sahits.game.openpatrician.engine.event.task.PostStateDialogToHumanPlayerTask;
import ch.sahits.game.openpatrician.engine.event.task.RefitShipTask;
import ch.sahits.game.openpatrician.engine.event.task.RepairPirateShipTask;
import ch.sahits.game.openpatrician.engine.event.task.RepairTask;
import ch.sahits.game.openpatrician.engine.event.task.ShipBuildTask;
import ch.sahits.game.openpatrician.engine.event.task.UpdatePopulationTask;
import ch.sahits.game.openpatrician.engine.event.task.WaitForShipArrival;
import ch.sahits.game.openpatrician.engine.event.task.WeaponConstructionTask;
import ch.sahits.game.openpatrician.engine.event.task.WeeklyCityCheckTask;
import ch.sahits.game.openpatrician.engine.event.task.WeeklyLoanerCheckTask;
import ch.sahits.game.openpatrician.engine.player.DailyPlayerUpdater;
import ch.sahits.game.openpatrician.engine.time.DailyUpdateTask;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.IShipBuildTask;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IArmory;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ServerSideTaskFactory
extends ClientServerTaskFactory {
    @Autowired
    private ApplicationContext context;

    public TimedTask getRepairTask(LocalDateTime executionTime, IShip ship, ICityPlayerProxyJFX proxy, IShipyard shipyard) {
        Object[] args = new Object[]{executionTime, ship, proxy, shipyard};
        return (RepairTask)((Object)this.context.getBean("repairTask", args));
    }

    public IShipBuildTask getShipBuildTask(LocalDateTime executionTime, EShipType type, IPlayer owner, Point2D location, IShipyard shipyard) {
        Object[] args = new Object[]{executionTime, type, owner, location, shipyard};
        return (ShipBuildTask)((Object)this.context.getBean("shipBuildTask", args));
    }

    public TimedTask getRefitShipTask(LocalDateTime executionTime, IShip ship, EShipUpgrade upgrade, ICityPlayerProxyJFX proxy, IShipyard shipyard) {
        Object[] args = new Object[]{executionTime, ship, upgrade, proxy, shipyard};
        return (RefitShipTask)((Object)this.context.getBean("refitShipTask", args));
    }

    public TimedTask getPirateRepairTask(LocalDateTime dueDate, INavigableVessel vessel, ISeaPirate owner, IShipyard shipyard) {
        Object[] args = new Object[]{dueDate, vessel, owner, shipyard};
        return (RepairPirateShipTask)((Object)this.context.getBean("repairPirateShipTask", args));
    }

    public TimedTask getAIShipRepairTask(LocalDateTime dueDate, IShip ship, IShipyard shipyard) {
        Object[] args = new Object[]{dueDate, ship, shipyard};
        return (TimedTask)this.context.getBean(AIRepairTask.class, args);
    }

    public TimedTask getAIShipRefitTask(LocalDateTime dueDate, IShip ship, EShipUpgrade upgrade, IShipyard shipyard) {
        Object[] args = new Object[]{dueDate, ship, upgrade, shipyard};
        return (TimedTask)this.context.getBean(AIRefitTask.class, args);
    }

    public TimedTask getWeeklyLoanerCheck() {
        return (TimedTask)this.context.getBean(WeeklyLoanerCheckTask.class);
    }

    public TimedTask getDailyAIPlayerCheck() {
        return (TimedTask)this.context.getBean(DailyPlayerUpdater.class);
    }

    public TimedTask getPeriodicalDailyUpdateTask() {
        return (TimedTask)this.context.getBean(DailyUpdateTask.class);
    }

    public TimedTask getWeeklyCityCheck() {
        return (TimedTask)this.context.getBean(WeeklyCityCheckTask.class);
    }

    public MarriageOfferTask getMarriageOfferTask(IAIPlayer player, MarriageBrokerAnnouncementState state, LocalDateTime deadLine) {
        return (MarriageOfferTask)((Object)this.context.getBean("marriageOfferTask", new Object[]{player, state, deadLine}));
    }

    public ChurchUpgradeTimedTask getChurchUpgradeTask(IChurch church, LocalDateTime deadline) {
        return (ChurchUpgradeTimedTask)((Object)this.context.getBean("churchUpgradeTimedTask", new Object[]{church, deadline}));
    }

    public LoanerCollectMoneyAfterAuctionTimedTask getLoanerCollectMoneyAfterAuctionTask(IDebt debt, LocalDateTime deadline) {
        return (LoanerCollectMoneyAfterAuctionTimedTask)((Object)this.context.getBean("loanerCollectMoneyAfterAuctionTimedTask", new Object[]{debt, deadline}));
    }

    public LoanerCollectMoneyWithoutAuctionTimedTask getLoanerCollectMoneyTask(IDebt debt, IPlayer debitor, LocalDateTime deadline) {
        return (LoanerCollectMoneyWithoutAuctionTimedTask)((Object)this.context.getBean("loanerCollectMoneyWithoutAuctionTimedTask", new Object[]{debt, debitor, deadline}));
    }

    public MarriageOfferDeclinedTimedTask getMarriageOfferDeclinedTask(IPlayer player) {
        return (MarriageOfferDeclinedTimedTask)((Object)this.context.getBean("marriageOfferDeclinedTimedTask", new Object[]{player}));
    }

    public WeaponConstructionTask getWeaponConstructionFinishedTask(IArmory armory, EWeapon weapon) {
        return (WeaponConstructionTask)((Object)this.context.getBean("weaponConstructionTask", new Object[]{armory, weapon}));
    }

    public UpdatePopulationTask getUpdatePopulationTask(LocalDateTime executionTime, EPopulationClass populationClass, int delta, ICity city) {
        return (UpdatePopulationTask)((Object)this.context.getBean(UpdatePopulationTask.class, new Object[]{executionTime, populationClass, delta, city}));
    }

    public ClearCityEventTask getClearCityEventTask(LocalDateTime executionTime, ICity city) {
        return (ClearCityEventTask)((Object)this.context.getBean(ClearCityEventTask.class, new Object[]{executionTime, city}));
    }

    public PostStateDialogToHumanPlayerTask getPostStateDialogMessageTask(LocalDateTime executionTime, EMessageCategory category, IDialogState state, IPlayer player, String messageKey, Object[] messageParams) {
        return (PostStateDialogToHumanPlayerTask)((Object)this.context.getBean(PostStateDialogToHumanPlayerTask.class, new Object[]{executionTime, category, state, player, messageKey, messageParams}));
    }

    public WaitForShipArrival waitForShipArrival(INavigableVessel waitingVessel, INavigableVessel waitingOnVessel, ICity waitingIn, Runnable actionUponArrival, boolean waitingShipArrived) {
        Object[] params = new Object[]{waitingVessel, waitingOnVessel, waitingIn, actionUponArrival, waitingShipArrived};
        return (WaitForShipArrival)this.context.getBean(WaitForShipArrival.class, params);
    }
}

