/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ISpecialMission;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.MODEL, EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WaitForShipArrival
implements ISpecialMission {
    private final INavigableVessel waitingVessel;
    private final INavigableVessel waitingOnVessel;
    private final ICity waitingIn;
    private final Runnable actionUponArrival;
    private boolean waitingShipArrived = false;
    private boolean waitedShipArrived = false;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public WaitForShipArrival(INavigableVessel waitingVessel, INavigableVessel waitingOnVessel, ICity waitingIn, Runnable actionUponArrival, boolean waitingShipArrived) {
        this.waitingVessel = waitingVessel;
        this.waitingOnVessel = waitingOnVessel;
        this.waitingIn = waitingIn;
        this.actionUponArrival = actionUponArrival;
        this.waitingShipArrived = waitingShipArrived;
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @Subscribe
    public void handleShipArrivesInCity(ShipEntersPortEvent event) {
        if (this.waitingIn.equals(event.getCity())) {
            if (this.waitingVessel.equals(event.getShip())) {
                this.waitingShipArrived = true;
            }
            if (this.waitingOnVessel.equals(event.getShip())) {
                this.waitedShipArrived = true;
            }
        }
        if (this.waitingShipArrived && this.waitedShipArrived) {
            this.actionUponArrival.run();
            this.clientServerEventBus.unregister((Object)this);
        }
    }
}

