/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.PeopleFactory;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.CaptainProperties;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CaptainEngine
extends AbstractEngine {
    @Autowired
    private Date date;
    @Autowired
    private IMap map;
    @Autowired
    private Random rnd;
    @Autowired
    private CaptainsState captainsState;
    @Autowired
    private PeopleFactory peopleFactory;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private CaptainProperties captainProperties;

    @PostConstruct
    public void init() {
        for (int i = 0; i < this.captainProperties.getMax(); ++i) {
            ICity city = this.getRandomCity();
            LocalDateTime currentDate = this.date.getCurrentDate();
            double nextGaussian = this.rnd.nextDouble();
            LocalDateTime arrival = currentDate.minusDays((int)Math.rint(nextGaussian * (double)this.captainProperties.getTimeInTown()));
            ICaptain captain = this.peopleFactory.createNewCaptainProperty();
            this.captainsState.addCaptain(city, arrival, captain);
        }
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    private ICity getRandomCity() {
        List cities = this.map.getCities();
        return (ICity)cities.get(this.rnd.nextInt(cities.size()));
    }

    @Subscribe
    public void handleDayChange(ClockTickDayChange event) {
        LocalDateTime today = this.date.getCurrentDate();
        LocalDateTime shouldLeaveWhenArrivedBefore = today.minusDays(this.captainsState.getMaxDaysPresent());
        for (ICaptain captain : this.captainsState.getAllFreeCaptains()) {
            LocalDateTime arrival;
            Optional city = this.captainsState.findCaptainsCurrentCity(captain);
            if (!city.isPresent() || !(arrival = this.captainsState.getArrivalDate(captain)).isBefore(shouldLeaveWhenArrivedBefore)) continue;
            ICity nextCity = this.getRandomCity();
            while (((ICity)city.get()).equals(nextCity)) {
                nextCity = this.getRandomCity();
            }
            double distance = Math.abs(((ICity)city.get()).getCoordinates().getX() - nextCity.getCoordinates().getX());
            double percentage = distance / this.map.getDimension().getWidth();
            int days = (int)Math.rint(10.0 * percentage);
            this.captainsState.hireCaptain(captain, (ICity)city.get());
            LocalDateTime arrivalDate = this.date.getCurrentDate().plusDays(days);
            this.captainsState.assignCaptainToCity(captain, (ICity)city.get(), arrivalDate);
        }
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Lists.newArrayList();
    }
}

