/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DateService;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.land.city.internal.AuctionEngine;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IAuction;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class GuildEngine
extends AbstractEngine {
    @Autowired
    private StateFactory stateFactory;
    @Autowired
    private GuildList guildList;
    @Autowired
    private DateService dateService;
    @Autowired
    private AIPlayerList aiPlayers;
    @Autowired
    private AuctionEngine auctionEngine;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;

    @PostConstruct
    private void init() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    public void establishGuild(ICity city) {
        this.stateFactory.createGuild(city);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        ArrayList engines = Lists.newArrayList();
        engines.add(this.auctionEngine);
        return engines;
    }

    @Subscribe
    public void handleDailyUpdate(ClockTickDayChange event) {
        for (IGuild guild : this.guildList) {
            for (IAuction auction : guild.getAuctions()) {
                if (!this.dateService.isToday(auction.getAuctionDate())) continue;
                this.handleAuction(auction, guild);
                guild.resetAuction(auction);
            }
        }
    }

    private void handleAuction(IAuction auction, IGuild guild) {
        List bidders = this.aiPlayers.findAIPlayersCurrentlyInCity(guild.getCity());
        bidders.removeIf(player -> !guild.getMembers().contains(player));
        this.auctionEngine.startAuction(auction, bidders);
    }
}

