/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.EngineFactory;
import ch.sahits.game.openpatrician.event.data.AuctionBid;
import ch.sahits.game.openpatrician.event.data.AuctionBidLevel;
import ch.sahits.game.openpatrician.event.data.BuildingAuctionFinished;
import ch.sahits.game.openpatrician.event.data.BuildingNotAuctioned;
import ch.sahits.game.openpatrician.event.data.ShipAuctionFinished;
import ch.sahits.game.openpatrician.event.data.ShipNotAuctioned;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.guild.EBidLevel;
import ch.sahits.game.openpatrician.model.city.guild.IAuction;
import ch.sahits.game.openpatrician.model.city.guild.IBuildingAuction;
import ch.sahits.game.openpatrician.model.city.guild.IShipAuction;
import ch.sahits.game.openpatrician.utilities.CancelableRunnable;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class AuctionEngine
extends AbstractEngine {
    public static final int BID_DELTA = 500;
    @Autowired
    @Qualifier(value="serverTimer")
    private ScheduledExecutorService timer;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private EngineFactory factory;

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void startAuction(final IAuction auction, List<IAIPlayer> players) {
        CancelableRunnable task;
        auction.setCurrentBid(auction.getStartingBid() - 500);
        Iterator<IAIPlayer> iterator = players.iterator();
        while (iterator.hasNext()) {
            IAIPlayer player = iterator.next();
            ICompany company = player.getCompany();
            if (company.getCash() >= (long)(auction.getStartingBid() * 3)) continue;
            iterator.remove();
        }
        auction.setBiddingPlayers(players);
        if (players.isEmpty()) {
            task = new CancelableRunnable(){
                private boolean run = true;

                public void cancel() {
                    this.run = false;
                }

                public void run() {
                    if (this.run) {
                        if (auction instanceof IShipAuction) {
                            if (auction.getOwner().isPresent()) {
                                IShipAuction shipAuction = (IShipAuction)auction;
                                AuctionEngine.this.clientServerEventBus.post((Object)new ShipNotAuctioned(shipAuction.getAuctionedShip(), (IPlayer)shipAuction.getOwner().get()));
                            }
                        } else {
                            IBuildingAuction buildingAuction = (IBuildingAuction)auction;
                            AuctionEngine.this.clientServerEventBus.post((Object)new BuildingNotAuctioned(buildingAuction.getAuctionedBuilding(), (IPlayer)buildingAuction.getOwner().get()));
                        }
                    }
                }
            };
            auction.setCurrentTask(task);
            this.timer.schedule((Runnable)task, 2L, TimeUnit.MINUTES);
        } else {
            task = this.factory.createNextBidTask(auction);
            auction.setCurrentTask(task);
            this.timer.schedule((Runnable)task, 30L, TimeUnit.SECONDS);
        }
    }

    @Subscribe
    public void handleBid(AuctionBid bid) {
        Preconditions.checkArgument((!bid.getBidder().equals(bid.getAuction().getBiddingPlayer()) ? 1 : 0) != 0, (Object)"The bidder has to change");
        IAuction auction = bid.getAuction();
        auction.getCurrentTask().cancel();
        auction.setBidLevel(EBidLevel.INITIAL);
        auction.setBiddingPlayer(bid.getBidder());
        auction.setCurrentBid(bid.getAmount());
        this.clientServerEventBus.post((Object)new AuctionBidLevel(auction.getBidLevel(), EBidLevel.INITIAL, bid.getBidder(), auction));
        CancelableRunnable task = this.factory.createNextBidTask(auction);
        auction.setCurrentTask(task);
        this.timer.schedule((Runnable)task, 30L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleBidLevelChange(AuctionBidLevel change) {
        IAuction auction = change.getAuction();
        auction.setBidLevel(change.getNewLevel());
        auction.setBiddingPlayer(change.getBidder());
        if (change.getNewLevel() == EBidLevel.DONE) {
            IPlayer newOwner = auction.getBiddingPlayer();
            int amount = auction.getCurrentBid();
            if (auction.getOwner().isPresent() && auction.getOwner().get() instanceof IPlayer) {
                if (auction.getOwner().get() instanceof IHumanPlayer) {
                    ((IPlayer)auction.getOwner().get()).getCompany().updateCash((long)amount);
                } else {
                    ((IPlayer)auction.getOwner().get()).getCompany().updateCashDirectly((long)amount);
                }
            }
            if (newOwner instanceof IHumanPlayer) {
                newOwner.getCompany().updateCash((long)(-amount));
            } else {
                newOwner.getCompany().updateCashDirectly((long)(-amount));
            }
            if (change.getAuction() instanceof IShipAuction) {
                IShipAuction shipAuction = (IShipAuction)auction;
                this.clientServerEventBus.post((Object)new ShipAuctionFinished(shipAuction.getAuctionedShip(), newOwner));
            } else {
                IBuildingAuction buildingAuction = (IBuildingAuction)auction;
                this.clientServerEventBus.post((Object)new BuildingAuctionFinished(buildingAuction.getAuctionedBuilding(), newOwner));
            }
        } else {
            CancelableRunnable task = this.factory.createNextBidTask(change.getAuction());
            this.timer.schedule((Runnable)task, 30L, TimeUnit.SECONDS);
        }
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Lists.newArrayList();
    }
}

