/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Election;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.OpenPatricianRandom;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.collections.SortedMapRandomizedSameElements;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ElectionTask
extends TimedTask {
    @XStreamOmitField
    private static final Logger LOGGER = LoggerFactory.getLogger(ElectionTask.class);
    @Autowired
    @XStreamOmitField
    private OpenPatricianRandom oprnd;
    private final SortedMapRandomizedSameElements candidateMap;
    private final Election result;
    private final ICity city;

    public ElectionTask(SortedMapRandomizedSameElements candidateMap, Election result, LocalDateTime electionTime, ICity city) {
        this.candidateMap = candidateMap;
        this.result = result;
        this.city = city;
        this.setExecutionTime(electionTime);
    }

    public void run() {
        int index = this.oprnd.nextSlidingRandomDecreasing(this.candidateMap.size() - 1, 0.5);
        List citizens = this.candidateMap.getAtIndex(index);
        this.result.vote((ICitizen)citizens.get(0));
        LOGGER.debug("Cast vote");
    }

    public String toString() {
        return "ElectionTask{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", Cast vote for " + this.result.getType() + " in " + this.city.getName() + "}";
    }
}

