/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.event.data.ShipAttackEvent;
import ch.sahits.game.openpatrician.event.data.ShipDefenseEvent;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@DependentInitialisation(value=StartNewGameBean.class)
public class ReputationEngine
extends AbstractEngine {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private SeaPiratesState piratesState;
    @Autowired
    private IMap map;

    @Override
    public List<AbstractEngine> getChildren() {
        return Collections.emptyList();
    }

    @PostConstruct
    private void initialize() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void destroy() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handlePirateDefeated(ShipAttackEvent event) {
        INavigableVessel vessel = event.getAttackedShip();
        INavigableVessel attackingShip = event.getAttackingShip();
        this.updateReputationDueToPirateDefeat(vessel, attackingShip);
    }

    @Subscribe
    public void handlePirateDefeated(ShipDefenseEvent event) {
        INavigableVessel playerVessel = event.getAttackedShip();
        INavigableVessel attackingShip = event.getAttackingShip();
        this.updateReputationDueToPirateDefeat(attackingShip, playerVessel);
    }

    private void updateReputationDueToPirateDefeat(INavigableVessel pirateVessel, INavigableVessel playerVessel) {
        if (pirateVessel.getOwner() instanceof ISeaPirate && playerVessel.getOwner() instanceof IPlayer && !this.piratesState.getAllPirates().contains(pirateVessel.getOwner())) {
            IPlayer player = (IPlayer)playerVessel.getOwner();
            for (ICity city : this.map.getCities()) {
                city.getReputation(player).update(15);
            }
        }
    }
}

