/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.BuildingPermissionState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.SocialAdvancementDeficitState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.SocialAdvancementState;
import ch.sahits.game.openpatrician.engine.land.city.ReputationCalculator;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayStateMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class SocialRankChecker {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private PlayerList players;
    @Autowired
    private ReputationCalculator repCalculator;
    @Autowired
    private GuildList guildList;
    @Autowired
    private Date date;
    @Autowired
    private IMap map;

    public void doMonthlyCheck() {
        for (IPlayer player : this.players) {
            ESocialRank rank = player.getRank();
            if (this.isNextRankAchievable(player)) {
                ESocialRank nextRank = rank.getNextRank();
                player.updateRank(nextRank);
                if (player instanceof IHumanPlayer) {
                    SocialAdvancementState state = SocialAdvancementState.builder().location(player.getHometown().getName()).rank(nextRank).date(this.date.getCurrentDate()).build();
                    DisplayStateMessage message = new DisplayStateMessage(EMessageCategory.PERSONAL, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.socialAdvancement.title", (IDialogState)state, new Object[0]);
                    this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)message));
                }
            } else if (player instanceof IHumanPlayer && rank != ESocialRank.PATRICIAN && rank != ESocialRank.MAYOR && rank != ESocialRank.ALDERMAN) {
                boolean moneyMissing = this.notEnoughMoney(player);
                boolean reputationLow = this.isReputationTooLow(player);
                SocialAdvancementDeficitState state = SocialAdvancementDeficitState.builder().date(this.date.getCurrentDate()).location(player.getHometown().getName()).money(moneyMissing).reputation(reputationLow).build();
                DisplayStateMessage message = new DisplayStateMessage(EMessageCategory.PERSONAL, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.socialAdvancement.title", (IDialogState)state, new Object[0]);
                this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)message));
            }
            ICareer career = this.repCalculator.calculateCareer(player.getHometown(), player);
            player.setCareerLevel(career);
            for (ICity city : this.map.getCities()) {
                double rep;
                if (city.hasBuildingPermission(player) || !((rep = this.repCalculator.remapReputation(city, player)) > ESocialRank.BARGAINER.getSocialRank())) continue;
                city.addBuildingPermission(player);
                BuildingPermissionState state = BuildingPermissionState.builder().date(this.date.getCurrentDate()).location(city.getName()).player(player).build();
                if (!(player instanceof IHumanPlayer)) continue;
                DisplayStateMessage message = new DisplayStateMessage(EMessageCategory.PERSONAL, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.buildingPermission.title", (IDialogState)state, new Object[]{city.getName()});
                this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)message));
            }
        }
    }

    private boolean isNextRankAchievable(IPlayer player) {
        ESocialRank rank = player.getRank();
        if (rank == ESocialRank.PATRICIAN || rank == ESocialRank.MAYOR || rank == ESocialRank.ALDERMAN) {
            return false;
        }
        ICompany company = player.getCompany();
        ICity homeTown = player.getHometown();
        long compValue = company.getCompanyValue();
        ESocialRank nextRank = rank.getNextRank();
        double remapedRep = this.repCalculator.remapReputation(homeTown, player);
        if (compValue >= (long)nextRank.getCompanyValue() && remapedRep >= nextRank.getSocialRank()) {
            if (nextRank == ESocialRank.COUNCILMAN) {
                IGuild guild = (IGuild)this.guildList.findGuild(homeTown).get();
                return guild.getMembers().contains(player);
            }
            return true;
        }
        return false;
    }

    private boolean isReputationTooLow(IPlayer player) {
        ESocialRank rank = player.getRank();
        ESocialRank nextRank = rank.getNextRank();
        double remapedRep = this.repCalculator.remapReputation(player.getHometown(), player);
        return remapedRep < nextRank.getSocialRank();
    }

    private boolean notEnoughMoney(IPlayer player) {
        ESocialRank rank = player.getRank();
        ESocialRank nextRank = rank.getNextRank();
        ICompany company = player.getCompany();
        long compValue = company.getCompanyValue();
        return compValue < (long)nextRank.getCompanyValue();
    }
}

