/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.GuildService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public abstract class BaseJoinGuildStrategy
implements IAIGuildJoinStrategy {
    private static final int ENTRY_FEE_FACTOR = 10;
    @Autowired
    private GuildList guildList;
    @Autowired
    private GuildService guildService;

    public boolean shouldJoin(IAIPlayer player, ICity city, Optional<INavigableVessel> vessel) {
        Optional maybeGuild = this.guildList.findGuild(city);
        if (maybeGuild.isPresent()) {
            IGuild guild = (IGuild)maybeGuild.get();
            if (guild.getMembers().contains(player)) {
                return false;
            }
            ICompany company = player.getCompany();
            int fee = this.guildService.getEntryFee((IPlayer)player);
            return (long)(fee * 10) < company.getCash() && this.additionalJoinRequirementsMet(player, city, vessel);
        }
        return false;
    }

    protected abstract boolean additionalJoinRequirementsMet(IAIPlayer var1, ICity var2, Optional<INavigableVessel> var3);

    public void join(IAIPlayer player, ICity city) {
        ICompany company = player.getCompany();
        Optional maybeGuild = this.guildList.findGuild(city);
        IGuild guild = (IGuild)maybeGuild.get();
        int fee = this.guildService.getEntryFee((IPlayer)player);
        company.updateCashDirectly((long)(-fee));
        guild.join((IPlayer)player);
    }
}

