/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.player.strategy.BaseBuyWeaponStrategy;
import ch.sahits.game.openpatrician.engine.sea.DangerService;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivity;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivityEntry;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.BuyWeapons;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class BuyWeaponHighPirateActivityHalfSlotsFilledStrategy
extends BaseBuyWeaponStrategy {
    @Autowired
    private PirateActivity pirateActivity;
    @Autowired
    @XStreamOmitField
    private DangerService dangerService;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;
    private static final long CASH_LIMIT = 10000L;

    public Optional<BuyWeapons> shouldBuyWeapons(IShip ship, IAIPlayer player, ICity city) {
        int limitNumberOfFewAttacks;
        long cash = player.getCompany().getCash();
        int numberOfFreeSlots = this.getNumberOfEmptyWeaponSlots(ship);
        int numberOfFreeLargeSlots = this.getNumberOfEmptyLargeWeaponSlots(ship);
        List<PirateActivityEntry> attacks = this.pirateActivity.getPirateActivity();
        int numberOfAttacks = this.dangerService.getNumberOfPirateAttacks(attacks);
        if (numberOfAttacks > (limitNumberOfFewAttacks = this.pirateActivity.getObservationPeriodInDays() / 14) && numberOfFreeSlots > 0 && cash > 10000L && ship.getCapacity() > 0) {
            int nbHandWeapons = Math.max(0, ship.getNumberOfSailors() - ship.getWeaponAmount((IWeapon)EWeapon.HAND_WEAPON));
            int largeWeapons = (int)Math.min(Math.round((double)numberOfFreeLargeSlots / 2.0), (long)(ship.getCapacity() / 2));
            int smallWeapons = Math.min(Math.max(0, numberOfFreeSlots - largeWeapons * 2) / 2, ship.getCapacity());
            int existingStrength = this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship);
            int targetStrength = (int)((double)numberOfFreeSlots * 0.65) + existingStrength;
            if (largeWeapons == 0 && smallWeapons == 0) {
                targetStrength = existingStrength;
            }
            if (nbHandWeapons > 0 || largeWeapons > 0 || smallWeapons > 0) {
                return Optional.of(BuyWeapons.builder().handWeapons(nbHandWeapons).smallWeapons(smallWeapons).largeWeapons(largeWeapons).totalStrength(targetStrength).weaponOrder(Arrays.asList(EWeapon.HAND_WEAPON, EWeapon.BOMBARD, EWeapon.TREBUCHET_BIG, EWeapon.BALLISTA_BIG, EWeapon.CANNON, EWeapon.TREBUCHET_SMALL, EWeapon.BALLISTA_SMALL)).build());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

