/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class BuyTradingOfficeTradeStep
implements ITradeStep {
    private ICity city;
    private ITradingOffice tradingOffice;
    private IWare ware;
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;
    private int maxBuyPrice;
    private long retainCash = 0L;

    public boolean execute() {
        IWare ware = this.getWare();
        IPlayer player = this.tradingOffice.getOwner();
        int maxAmount = this.tradingOffice.capacityProperty().get() - this.tradingOffice.getOccupiedSpace();
        if (!ware.isBarrelSizedWare()) {
            maxAmount /= 10;
        }
        this.tradeService.buyFromCityToStorage(this.tradingOffice, player, this.city, ware, maxAmount, Optional.of(this.maxBuyPrice), this.tradingOffice.getSteward(), this.retainCash);
        return true;
    }

    public String toString() {
        return "BuyTradingOfficeTradeStep player " + this.tradingOffice.getOwner().getUuid() + " {Buy " + this.getWare() + " in " + this.getCity().getName() + "}";
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    protected ICity getCity() {
        return this.city;
    }

    public void setTradingOffice(ITradingOffice tradingOffice) {
        this.tradingOffice = tradingOffice;
    }

    public ITradingOffice getTradingOffice() {
        return this.tradingOffice;
    }

    public void setWare(IWare ware) {
        this.ware = ware;
    }

    public IWare getWare() {
        return this.ware;
    }

    public void setMaxBuyPrice(int maxBuyPrice) {
        this.maxBuyPrice = maxBuyPrice;
    }

    public void setRetainCash(long retainCash) {
        this.retainCash = retainCash;
    }
}

