/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.engine.player.tradesteps.BaseBuyTradeStep;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class CheckedBuyTradeStep
extends BaseBuyTradeStep {
    private boolean executeNext = true;
    private long cost = 0L;

    public boolean execute() {
        IWare ware = this.getWare();
        INavigableVessel vessel = this.getVessel();
        IPlayer player = (IPlayer)vessel.getOwner();
        int size = vessel.getSize();
        int alreadyLoaded = vessel.getWare(ware).getAmount();
        int maxAmountBasedOnPercentage = (int)((double)size * ware.getAiMaxBuyPercentage()) - alreadyLoaded;
        int maxAbsoluteAmount = ware.getAiMaxBuyAbsolute() - alreadyLoaded;
        int affordableAmount = Math.min(maxAmountBasedOnPercentage, maxAbsoluteAmount);
        this.cost = this.transferFromOfficeOrBuyFromCity(player, affordableAmount);
        return this.executeNext;
    }

    public String toString() {
        return "CheckedBuyTradeStep " + ((IPlayer)this.getVessel().getOwner()).getUuid() + "{Buy " + this.getWare() + " for " + this.getVessel().getName() + "(" + this.getVessel().getUuid() + ") in " + this.getCity().getName() + " for a max price of" + this.getMaxBuyPrice() + "}";
    }

    public void setExecuteNext(boolean executeNext) {
        this.executeNext = executeNext;
    }

    public long getCost() {
        return this.cost;
    }
}

