/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class CheckedSellTradeStep
implements ITradeStep {
    private ICity city;
    private IWare ware;
    private int maxAmount;
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;
    private boolean executeNext = true;

    public boolean execute() {
        int minSellPrice = this.vessel.getWare(this.ware).getAVGPrice();
        IAIPlayer player = (IAIPlayer)this.vessel.getOwner();
        this.tradeService.sellWareShipToCity(this.vessel, (IPlayer)player, this.city, this.ware, this.maxAmount, Optional.of(minSellPrice));
        return this.executeNext;
    }

    public String toString() {
        return "CheckedSellTradeStep player " + ((IPlayer)this.vessel.getOwner()).getUuid() + " {Sell " + this.getWare() + " for " + this.vessel.getName() + "(" + this.vessel.getUuid() + ") in " + this.city.getName() + " for a min price of" + this.vessel.getWare(this.getWare()).getAVGPrice() + "}";
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setWare(IWare ware) {
        this.ware = ware;
    }

    public IWare getWare() {
        return this.ware;
    }

    public void setMaxAmount(int maxAmount) {
        this.maxAmount = maxAmount;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public void setExecuteNext(boolean executeNext) {
        this.executeNext = executeNext;
    }
}

