/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.graphic.image.ECircleSegment;
import ch.sahits.game.graphic.image.IMapImageServiceFacade;
import ch.sahits.game.graphic.image.model.MapGrid;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import com.carrotsearch.hppc.ObjectByteMap;
import com.carrotsearch.hppc.ObjectByteScatterMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Interner;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseGraphCalulationService
implements MapGrid {
    @Autowired
    protected IMapImageServiceFacade imageService;
    @Autowired
    protected IMap map;
    @Autowired
    protected Interner<Point2D> pointInterner;
    @MapType(key=Point2D.class, value=Byte.class)
    private ObjectByteMap<Point2D> onSea = new ObjectByteScatterMap();

    protected Point2D getPoint(double x, double y) {
        return (Point2D)this.pointInterner.intern((Object)new Point2D(x, y));
    }

    protected abstract double calculateWeight(Point2D var1, Point2D var2);

    @VisibleForTesting
    protected List<ECircleSegment> getSegments(Point2D from, Point2D to) {
        ArrayList<ECircleSegment> segments = new ArrayList<ECircleSegment>();
        if (from.equals((Object)to)) {
            return segments;
        }
        double xVec = to.getX() - from.getX();
        double yVec = to.getY() - from.getY();
        double angle = Math.toDegrees(Math.atan(yVec / xVec)) + 90.0;
        if (xVec < 0.0) {
            angle += 180.0;
        }
        if (angle < 22.5) {
            segments.add(ECircleSegment.TOPLEFT);
            segments.add(ECircleSegment.TOPRIGHT);
        } else if (angle < 67.5) {
            segments.add(ECircleSegment.TOPRIGHT);
        } else if (angle < 112.5) {
            segments.add(ECircleSegment.TOPRIGHT);
            segments.add(ECircleSegment.BOTTOMRIGHT);
        } else if (angle < 157.5) {
            segments.add(ECircleSegment.BOTTOMRIGHT);
        } else if (angle < 202.5) {
            segments.add(ECircleSegment.BOTTOMRIGHT);
            segments.add(ECircleSegment.BOTTOMLEFT);
        } else if (angle < 247.5) {
            segments.add(ECircleSegment.BOTTOMLEFT);
        } else if (angle < 292.5) {
            segments.add(ECircleSegment.BOTTOMLEFT);
            segments.add(ECircleSegment.TOPLEFT);
        } else if (angle < 337.5) {
            segments.add(ECircleSegment.TOPLEFT);
        } else {
            segments.add(ECircleSegment.TOPLEFT);
            segments.add(ECircleSegment.TOPRIGHT);
        }
        return segments;
    }

    @VisibleForTesting
    protected List<ECircleSegment> getTangentialSegments(Point2D from, Point2D to) {
        ArrayList<ECircleSegment> segments = new ArrayList<ECircleSegment>();
        if (from.equals((Object)to)) {
            return segments;
        }
        double xVec = to.getX() - from.getX();
        double yVec = to.getY() - from.getY();
        double angle = Math.toDegrees(Math.atan(yVec / xVec)) + 90.0;
        if (xVec < 0.0) {
            angle += 180.0;
        }
        if (angle < 22.5) {
            segments.add(ECircleSegment.TOPLEFT);
            segments.add(ECircleSegment.TOPRIGHT);
            segments.add(ECircleSegment.BOTTOMRIGHT);
            segments.add(ECircleSegment.BOTTOMLEFT);
        } else if (angle < 67.5) {
            segments.add(ECircleSegment.TOPLEFT);
            segments.add(ECircleSegment.BOTTOMRIGHT);
        } else if (angle < 112.5) {
            segments.add(ECircleSegment.TOPLEFT);
            segments.add(ECircleSegment.TOPRIGHT);
            segments.add(ECircleSegment.BOTTOMRIGHT);
            segments.add(ECircleSegment.BOTTOMLEFT);
        } else if (angle < 157.5) {
            segments.add(ECircleSegment.TOPRIGHT);
            segments.add(ECircleSegment.BOTTOMLEFT);
        } else if (angle < 202.5) {
            segments.add(ECircleSegment.TOPLEFT);
            segments.add(ECircleSegment.TOPRIGHT);
            segments.add(ECircleSegment.BOTTOMRIGHT);
            segments.add(ECircleSegment.BOTTOMLEFT);
        } else if (angle < 247.5) {
            segments.add(ECircleSegment.TOPLEFT);
            segments.add(ECircleSegment.BOTTOMRIGHT);
        } else if (angle < 292.5) {
            segments.add(ECircleSegment.TOPLEFT);
            segments.add(ECircleSegment.TOPRIGHT);
            segments.add(ECircleSegment.BOTTOMRIGHT);
            segments.add(ECircleSegment.BOTTOMLEFT);
        } else if (angle < 337.5) {
            segments.add(ECircleSegment.TOPRIGHT);
            segments.add(ECircleSegment.BOTTOMLEFT);
        } else {
            segments.add(ECircleSegment.TOPLEFT);
            segments.add(ECircleSegment.TOPRIGHT);
            segments.add(ECircleSegment.BOTTOMRIGHT);
            segments.add(ECircleSegment.BOTTOMLEFT);
        }
        return segments;
    }

    public boolean isOnSea(Point2D point) {
        if (this.onSea.containsKey((Object)point)) {
            return this.mapByteToBoolean(this.onSea.get((Object)point));
        }
        int x = (int)point.getX();
        int y = (int)point.getY();
        boolean onSea = this.imageService.isOnSea(x, y);
        this.onSea.put((Object)point, this.mapBooleanToByte(onSea));
        return onSea;
    }

    private boolean mapByteToBoolean(Byte b) {
        return b == 0;
    }

    private byte mapBooleanToByte(boolean b) {
        if (b) {
            return 0;
        }
        return 1;
    }
}

