/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea.model;

import ch.sahits.game.event.data.ClockTickIntervalChange;
import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.event.data.ResumeGame;
import ch.sahits.game.openpatrician.clientserverinterface.model.PathInterpolatorMap;
import ch.sahits.game.openpatrician.clientserverinterface.model.VesselPositionUpdateData;
import ch.sahits.game.openpatrician.clientserverinterface.service.IPathConverter;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.PathInterpolator;
import ch.sahits.game.openpatrician.clientserverinterface.service.PointService;
import ch.sahits.game.openpatrician.event.EGameStatusChange;
import ch.sahits.game.openpatrician.event.GameStateChange;
import ch.sahits.game.openpatrician.event.data.ShipArrivesAtDestinationEvent;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.data.ShipLeavingPort;
import ch.sahits.game.openpatrician.event.data.ShipNearingPortEvent;
import ch.sahits.game.openpatrician.event.data.ShipPositionUpdateEvent;
import ch.sahits.game.openpatrician.model.DisplayInfoMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.PausableSchedulableTask;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.initialisation.MapInitializedBean;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.ship.IGroupableVessel;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
@DependentInitialisation(value=MapInitializedBean.class)
public class ShipPositionUpdateTask
extends PausableSchedulableTask {
    private static final Logger log = LoggerFactory.getLogger(ShipPositionUpdateTask.class);
    @Autowired
    private PathInterpolatorMap interpolators;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="syncServerClientEventBus")
    private EventBus syncServerClientEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private IMap map;
    @Autowired
    private IPathConverter pathConverter;
    @Autowired
    private PointService pointService;
    @Autowired
    private MapService mapService;
    private long pausedTimeStamp = -1L;

    @PostConstruct
    protected void register() {
        this.clientServerEventBus.register((Object)this);
        super.register();
        this.pause(new PauseGame());
    }

    @PreDestroy
    public void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        super.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(long now) {
        PathInterpolatorMap pathInterpolatorMap = this.interpolators;
        synchronized (pathInterpolatorMap) {
            Iterator iterator = this.interpolators.entrySet().iterator();
            while (iterator.hasNext()) {
                Optional city;
                Point2D source;
                Map.Entry entry = (Map.Entry)iterator.next();
                VesselPositionUpdateData value = (VesselPositionUpdateData)entry.getValue();
                INavigableVessel vessel = (INavigableVessel)entry.getKey();
                PathInterpolator interpolator = value.getInterpolator();
                double traveldFraction = interpolator.getTraveldFraction();
                double travelPerTick = interpolator.getTravelFractionPerTick();
                this.updateShipDamage(value, vessel, travelPerTick);
                double animationFraction = Math.min(1.0, traveldFraction + travelPerTick);
                Point2D newLocation = interpolator.interpolate(animationFraction);
                Point2D oldLocation = vessel.getLocation();
                vessel.setLocation(newLocation);
                this.syncServerClientEventBus.post((Object)new ShipPositionUpdateEvent(vessel, oldLocation, newLocation));
                log.trace("interpolate path for {} ({}) move to {}, fraction={}", new Object[]{vessel.getName(), vessel.getUuid(), newLocation, animationFraction});
                if (value.isSourceCity() && oldLocation.distance(source = value.getSource()) < 10.0 && newLocation.distance(source) >= 10.0) {
                    city = this.map.findCity(source);
                    if (city.isPresent()) {
                        this.clientServerEventBus.post((Object)new ShipLeavingPort(vessel, (ICity)city.get()));
                    } else {
                        log.error("Failed to find city at {}", (Object)source);
                    }
                }
                Point2D destination = value.getDestination();
                if (value.isDestinationCity() && newLocation.distance(destination) <= 10.0 && oldLocation.distance(destination) > 10.0) {
                    city = this.map.findCity(destination);
                    if (city.isPresent()) {
                        this.clientServerEventBus.post((Object)new ShipNearingPortEvent(vessel, (ICity)city.get()));
                    } else {
                        log.error("Failed to find city at {}", (Object)destination);
                    }
                }
                if (!this.pointService.equals(destination, newLocation)) continue;
                vessel.setLocation(destination);
                if (value.isDestinationCity()) {
                    city = this.map.findCity(destination);
                    if (city.isPresent()) {
                        this.clientServerEventBus.post((Object)new ShipEntersPortEvent(vessel, (ICity)city.get()));
                        if (vessel.getOwner() instanceof IHumanPlayer) {
                            DisplayInfoMessage msg = new DisplayInfoMessage("ch.sahits.game.openpatrician.engine.sea.model.ShipPositionUpdateTask.shipArrivedInCity", new Object[]{vessel.getName(), ((ICity)city.get()).getName()});
                            this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)vessel.getOwner(), (Object)msg));
                        }
                    } else {
                        log.error("Failed to find city at {}", (Object)destination);
                    }
                } else {
                    this.clientServerEventBus.post((Object)new ShipArrivesAtDestinationEvent(vessel, destination));
                    if (vessel.getOwner() instanceof IHumanPlayer) {
                        DisplayInfoMessage msg = new DisplayInfoMessage("ch.sahits.game.openpatrician.engine.sea.model.ShipPositionUpdateTask.shipArrivedAtDestination", new Object[]{vessel.getName()});
                        this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)vessel.getOwner(), (Object)msg));
                    }
                }
                iterator.remove();
            }
        }
    }

    @VisibleForTesting
    void updateShipDamage(VesselPositionUpdateData value, INavigableVessel vessel, double travelPerTick) {
        double distanceInKm = this.mapService.convertToDistenceInKm(travelPerTick);
        double distanceSinceLastDamageUpdate = value.getTraveledDistanceSinceLastDamageUpdate() + distanceInKm;
        if (vessel instanceof IShip) {
            IShip ship = (IShip)vessel;
            this.damageShip(value, distanceSinceLastDamageUpdate, ship);
        } else if (vessel instanceof IGroupableVessel) {
            for (IShip ship : ((IGroupableVessel)vessel).getShips()) {
                this.damageShip(value, distanceSinceLastDamageUpdate, ship);
            }
        }
    }

    private void damageShip(VesselPositionUpdateData value, double distanceSinceLastDamageUpdate, IShip ship) {
        int kmPerDamage = ship.getDistanceInKmForOneHealthPointReduction();
        if (distanceSinceLastDamageUpdate > (double)kmPerDamage) {
            int damagePoint = this.calculateDamagePoints(kmPerDamage, distanceSinceLastDamageUpdate);
            ship.damage(damagePoint, false);
            double remainingDistance = distanceSinceLastDamageUpdate - (double)(damagePoint * kmPerDamage);
            value.setTraveledDistanceSinceLastDamageUpdate(remainingDistance);
        } else {
            value.setTraveledDistanceSinceLastDamageUpdate(distanceSinceLastDamageUpdate);
        }
    }

    private int calculateDamagePoints(int kmPerDamage, double distanceSinceLastDamageUpdate) {
        int damage = 0;
        for (double tempDistance = distanceSinceLastDamageUpdate; tempDistance >= (double)kmPerDamage; tempDistance -= (double)kmPerDamage) {
            ++damage;
        }
        return damage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handleGameSpeedChange(ClockTickIntervalChange intervallChange) {
        PathInterpolatorMap pathInterpolatorMap = this.interpolators;
        synchronized (pathInterpolatorMap) {
            for (Map.Entry entry : this.interpolators.entrySet()) {
                VesselPositionUpdateData data = (VesselPositionUpdateData)entry.getValue();
                PathInterpolator interpolator = data.getInterpolator();
                double traveledFraction = interpolator.getTraveldFraction();
                double traveledTimeMS = (double)data.getDurationInMs() * traveledFraction;
                double fractionToTravel = 1.0 - traveledFraction;
                long remainingDuration = this.pathConverter.calculateDuration((INavigableVessel)entry.getKey(), interpolator, fractionToTravel);
                long newDuration = Math.round(traveledTimeMS + (double)remainingDuration);
                long nbTicks = remainingDuration / 100L;
                double fractionPerTick = fractionToTravel / (double)nbTicks;
                interpolator.setTravelFractionPerTick(fractionPerTick);
                data.setDurationInMs(newDuration);
                log.debug("Update the game speed, fraction to travel={}, nbTicks={}, remainingDuration={}, update fraction per tick={}", new Object[]{fractionToTravel, nbTicks, remainingDuration, fractionPerTick});
            }
        }
    }

    @Subscribe
    public void pause(PauseGame evt) {
        log.debug("Pause Task");
        this.pausedTimeStamp = System.currentTimeMillis();
        super.pause(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void resume(ResumeGame evt) {
        log.debug("Resume Task, paused timestamp: {}", (Object)this.pausedTimeStamp);
        long pausedDurationMS = System.currentTimeMillis() - this.pausedTimeStamp;
        PathInterpolatorMap pathInterpolatorMap = this.interpolators;
        synchronized (pathInterpolatorMap) {
            for (VesselPositionUpdateData data : this.interpolators.values()) {
                long originalStartTimestampMS = data.getAnimationStartMS();
                long newStartTimestampNS = originalStartTimestampMS + pausedDurationMS;
                data.setAnimationStartMS(newStartTimestampNS);
                log.trace("Change start time from {} -> {}", (Object)originalStartTimestampMS, (Object)newStartTimestampNS);
            }
        }
        super.resume(evt);
        this.pausedTimeStamp = -1L;
    }

    @Subscribe
    public void loadedGame(GameStateChange change) {
        if (change.getStatusChange() == EGameStatusChange.GAME_LOADED) {
            log.trace("Reset the time, so it is calculated correctly on resume, so that the distance to travel is correct");
            if (this.interpolators.isEmpty()) {
                log.trace("There are no ships traveling, so there is no need.");
            } else {
                for (Map.Entry entry : this.interpolators.entrySet()) {
                    VesselPositionUpdateData vesselData = (VesselPositionUpdateData)entry.getValue();
                    long totalDuration = vesselData.getDurationInMs();
                    double traveledFraction = vesselData.getInterpolator().getTraveldFraction();
                    long traveledTime = Math.round((double)totalDuration * traveledFraction);
                    long newStartTime = this.pausedTimeStamp - traveledTime;
                    vesselData.setAnimationStartMS(newStartTime);
                    log.trace("Update the ship {} ({}) with new start animation time {}; totalDuration={}, traveledFraction={}, traveledTime={}ms", new Object[]{((INavigableVessel)entry.getKey()).getName(), ((INavigableVessel)entry.getKey()).getUuid(), newStartTime, totalDuration, traveledFraction, traveledTime});
                }
            }
        }
    }
}

