package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.event.data.RepairFinishedEvent;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Component("aIRepairTask")
@Scope("prototype")
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class AIRepairTask extends TimedTask {
    @XStreamOmitField
    private static final Logger LOGGER = LoggerFactory.getLogger(AIRepairTask.class);
    @Autowired
    @XStreamOmitField
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;


    private final IShip ship;
    private final IShipyard shipyard;

    public AIRepairTask(LocalDateTime executionTime, IShip ship, IShipyard shipyard) {
        super();
        setExecutionTime(executionTime);
        LOGGER.debug("Add AIRepairTask for {} ({}) to be done at {}", ship.getName(), ship.getUuid(), executionTime);
        this.ship = ship;
        this.shipyard = shipyard;
    }

    @Override
    public void run() {
        ship.repair();
        shipyard.removeCompletedRepair(ship);
        ship.setAvailable(true);
        LOGGER.debug("Repaired ship {}", ship.getName());
        clientServerEventBus.post(new RepairFinishedEvent(ship));
    }

    @Override
    public String toString() {
        return "AIRepairTask{" +
                "UUID=" + getUuid() +
                ", execution at " + getExecutionTime() +
                ", ship="+ship.getUuid()+
                "}";
    }
}
