package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.data.RepairFinishedEvent;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class RepairTask extends TimedTask {
    @Autowired
    @XStreamOmitField
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier("messageSource")
    private MessageSource messageSource;

    private final IShip ship;
    protected final ICityPlayerProxyJFX city;
    private final IShipyard shipyard;

    public RepairTask(LocalDateTime executionTime, IShip ship, ICityPlayerProxyJFX city, IShipyard shipyard) {
        super();
        setExecutionTime(executionTime);
        this.ship = ship;
        this.city = city;
        this.shipyard = shipyard;
    }

    @Override
    public void run() {
        ship.repair();
        shipyard.removeCompletedRepair(ship);
        ship.setAvailable(true);
        city.getPlayersShips().add(ship);
        if (city.getPlayersShips().size() == 1) {
            city.activateShip(ship);
        }
        final IShipOwner owner = ship.getOwner();
        if (owner instanceof IHumanPlayer) {
            DisplayMessage msg = new DisplayMessage(EMessageCategory.PERSONAL, "ch.sahits.game.openpatrician.engine.event.task.RepairTask.message", new Object[]{ship.getName()});
            TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer) owner, msg);
            clientServerEventBus.post(displayMessage);
        } else {
            clientServerEventBus.post(new RepairFinishedEvent(ship));
        }
    }

    @Override
    public String toString() {
        return "RepairTask{" +
                "UUID=" + getUuid() +
                ", execution at " + getExecutionTime() +
                ", ship="+ship.getUuid()+
                '}';
    }
}
