package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;

import java.time.LocalDateTime;

/**
 * Timed task to update the population of a certain category.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Feb 03, 2018
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class UpdatePopulationTask extends TimedTask {

    private final EPopulationClass populationClass;
    private final int delta;
    private final ICity city;

    public UpdatePopulationTask(LocalDateTime executionTime, EPopulationClass populationClass, int delta, ICity city) {
        super();
        setExecutionTime(executionTime);
        this.populationClass = populationClass;
        this.delta = delta;
        this.city = city;
    }

    @Override
    public void run() {
        city.setPopulation(city.getPopulation(populationClass) + delta, populationClass);
    }

    @Override
    public String toString() {
        return "UpdatePopulationTask{" +
                "UUID=" + getUuid() +
                ", execution at " + getExecutionTime() +
                ", populationClass=" + populationClass +
                ", delta=" + delta +
                ", city=" + city.getName() +
                '}';
    }
}
