package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.land.city.internal.AuctionEngine;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.clientserverinterface.service.DateService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IAuction;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

/**
 * Engine to interact with the guild
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 06, 2016
 */
@Component
@Lazy
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class GuildEngine extends AbstractEngine {
    @Autowired
    private StateFactory stateFactory;
    @Autowired
    private GuildList guildList;
    @Autowired
    private DateService dateService;
    @Autowired
    private AIPlayerList aiPlayers;
    @Autowired
    private AuctionEngine auctionEngine;
    @Autowired
    @Qualifier("timerEventBus")
    private AsyncEventBus timerEventBus;
    @PostConstruct
    private void init() {
        timerEventBus.register(this);
    }
    @PreDestroy
    private void unregister() {
        timerEventBus.unregister(this);
    }

    public void establishGuild(ICity city) {
         stateFactory.createGuild(city);
    }
    @Override
    public List<AbstractEngine> getChildren() {
        ArrayList<AbstractEngine> engines = newArrayList();
        engines.add(auctionEngine);
        return engines;
    }
    @Subscribe
    public void handleDailyUpdate(ClockTickDayChange event) {
        for (IGuild guild : guildList) {
            for (IAuction auction : guild.getAuctions()) {
                if (dateService.isToday(auction.getAuctionDate())) {
                    handleAuction(auction, guild);
                    guild.resetAuction(auction);
                }
            }
        }
    }

    private void handleAuction(IAuction auction, IGuild guild) {
        List<IAIPlayer> bidders = aiPlayers.findAIPlayersCurrentlyInCity(guild.getCity());
        bidders.removeIf(player -> !guild.getMembers().contains(player));
        auctionEngine.startAuction(auction, bidders);
    }
}
