package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.engine.player.strategy.EAIRepairStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.ECollectCelebrationWareStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.ECollectConstructionWareStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EEventDecisionStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EGuildJoinStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EHireCaptainStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EHireSailorStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EHireTradeManagerStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EShipConstructionStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.ETakeLoanStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EUpgradeShipStrategyTypes;
import ch.sahits.game.openpatrician.engine.player.strategy.EWeaponBuyStrategyType;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategyType;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIHireSailorsStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIHireTradeManagerStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipUpgradeStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIStrategyProvider;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;

/**
 * Provide the AI strategies defined in the core module.
 */
@Service
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class DefaultStrategyProvider implements IAIStrategyProvider {
    @ListType(IAIShipRepairStrategyType.class)
    private static List<IAIShipRepairStrategyType> repairStrategies = new ArrayList<>();
    @ListType(IAIShipRepairStrategyType.class)
    private static List<IAITradeStrategyType> tradeStrategies = new ArrayList<>();
    @ListType(IAITradeStrategyType.class)
    private static List<IAITakeLoanStrategyType> takeLoanStrategies = new ArrayList<>();
    @ListType(IAIConstructionSelectionStrategyType.class)
    private static List<IAIConstructionSelectionStrategyType> constructionSelections = new ArrayList<>();
    @ListType(IAICaptainHireStrategyType.class)
    private static List<IAICaptainHireStrategyType> hireCaptainStrategies = new ArrayList<>();
    @ListType(IAICaptainHireStrategyType.class)
    private static List<IAIGuildJoinStrategyType> guildJoinStrategies = new ArrayList<>();
    @ListType(IAIEventDecisionStrategyType.class)
    private static List<IAIEventDecisionStrategyType> eventDecisionStrategies = new ArrayList<>();
    @ListType(IAIHireTradeManagerStrategyType.class)
    private static List<IAIHireTradeManagerStrategyType> hireTradeManagerStrategies = new ArrayList<>();
    @ListType(IAIBuyWeaponStrategyType.class)
    private static List<IAIBuyWeaponStrategyType> weaponBuyStrategies = new ArrayList<>();
    @ListType(IAIHireSailorsStrategyType.class)
    private static List<IAIHireSailorsStrategyType> hireSailorsStrategies = new ArrayList<>();
    @ListType(IAIShipUpgradeStrategyType.class)
    private static List<IAIShipUpgradeStrategyType> shipUpgradeStrategies = new ArrayList<>();
    @Autowired
    private ApplicationContext context;

    @PostConstruct
    private void init() {
        repairStrategies.add(EAIRepairStrategyType.EIGHTY_PERCENT);
        repairStrategies.add(EAIRepairStrategyType.ONLY_HOMEWOTN);
        repairStrategies.add(EAIRepairStrategyType.ONLY_KONTOR_TYPE);
        repairStrategies.add(EAIRepairStrategyType.ONLY_TRADINGOFFICE);
        repairStrategies.add(EAIRepairStrategyType.ONLY_WEST);
        for (IAIShipRepairStrategyType strategy : repairStrategies) {
            ((EAIRepairStrategyType)strategy).setApplicationContext(context);
        }
        tradeStrategies.add(EAITradeStrategyType.SUPPLY_HOMETOWN);
        tradeStrategies.add(EAITradeStrategyType.CHEAP_PRODUCTION);
        tradeStrategies.add(EAITradeStrategyType.TRADE_ROUTE);
        tradeStrategies.add(EAITradeStrategyType.PRODUCTION_CHAIN);
        for (IAITradeStrategyType strategy : tradeStrategies) {
            ((EAITradeStrategyType)strategy).setApplicationContext(context);
        }
        takeLoanStrategies.add(ETakeLoanStrategyType.LOW_MONEY_LONG_DURATION);
        for (IAITakeLoanStrategyType strategy : takeLoanStrategies) {
            ((ETakeLoanStrategyType)strategy).setApplicationContext(context);
        }
        constructionSelections.add(EShipConstructionStrategyType.HOMETOWN_BIGGEST);
        for (IAIConstructionSelectionStrategyType strategy : constructionSelections) {
            ((EShipConstructionStrategyType)strategy).setApplicationContext(context);
        }
        for (EHireCaptainStrategyType type : EHireCaptainStrategyType.values()) {
            hireCaptainStrategies.add(type);
            type.setApplicationContext(context);
        }
        for (EGuildJoinStrategyType type: EGuildJoinStrategyType.values()) {
            guildJoinStrategies.add(type);
            type.setApplicationContext(context);
        }
        for (EHireTradeManagerStrategyType type : EHireTradeManagerStrategyType.values()) {
            hireTradeManagerStrategies.add(type);
            type.setApplicationContext(context);
        }
        for (EEventDecisionStrategyType type : EEventDecisionStrategyType.values()) {
            eventDecisionStrategies.add(type);
            type.setApplicationContext(context);
        }
        for (EWeaponBuyStrategyType type : EWeaponBuyStrategyType.values()) {
            weaponBuyStrategies.add(type);
            type.setApplicationContext(context);
        }
        for (ECollectCelebrationWareStrategyType type : ECollectCelebrationWareStrategyType.values()) {
            type.setApplicationContext(context);
        }
        for (ECollectConstructionWareStrategyType type : ECollectConstructionWareStrategyType.values()) {
            type.setApplicationContext(context);
        }
        for (EHireSailorStrategyType type : EHireSailorStrategyType.values()) {
            hireSailorsStrategies.add(type);
            type.setApplicationContext(context);
        }
        for (EUpgradeShipStrategyTypes types : EUpgradeShipStrategyTypes.values()) {
            shipUpgradeStrategies.add(types);
            types.setApplicationContext(context);
        }
    }

    @Override
    public List<IAITradeStrategyType> getTradeStrategies() {
        return tradeStrategies;
    }

    @Override
    public List<IAIShipRepairStrategyType> getRepairStrategies() {
        return repairStrategies;
    }

    @Override
    public List<IAITakeLoanStrategyType> getTakeLoanStrategies() {
        return takeLoanStrategies;
    }

    @Override
    public List<IAIConstructionSelectionStrategyType> getConstructionSelectionStrategies() {
        return constructionSelections;
    }

    @Override
    public List<IAICaptainHireStrategyType> getCaptainHireStrategies() {
        return hireCaptainStrategies;
    }

    @Override
    public List<IAIGuildJoinStrategyType> getGuildJoinStrategies() {
        return guildJoinStrategies;
    }

    @Override
    public List<IAIEventDecisionStrategyType> getEventDecisionStrategies() {
        return eventDecisionStrategies;
    }

    @Override
    public List<IAIHireTradeManagerStrategyType> getHireTradeManagerStrategies() {
        return hireTradeManagerStrategies;
    }

    @Override
    public List<IAIBuyWeaponStrategyType> getWeaponBuyStrategies() {
        return weaponBuyStrategies;
    }

    @Override
    public List<IAIHireSailorsStrategyType> getHireSailorStrategies() {
        return hireSailorsStrategies;
    }

    @Override
    public List<IAIShipUpgradeStrategyType> getShipUpgradeStrategies() {
        return shipUpgradeStrategies;
    }
}
