package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.DonationRequestState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageFeastRequestState;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * Handle the events triggered by the EventEngine and targeted at an AI player
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 14, 2016
 */
public interface IAIEventHandler {
    /**
     * Handle the offer of a marriage broker.
      * @param state of the marriage broker
     */
    void handleMarriageEvent(IAIPlayer player, MarriageBrokerAnnouncementState state);


    /**
     * Handle the request to deliver marriage wares.
     * @param player that is requested to deliver the wares
     * @param state request details
     */
    void handleMarriageWareDelivery(IAIPlayer player, MarriageFeastRequestState state);

    /**
     * Handle a donation request.
     * @param player that is requested to deliver the wares
     * @param state request details
     */
    void handleDonationRequest(IAIPlayer player, DonationRequestState state);

    /**
     * Method to handle the initializing of a trade strategy for a new ship.
     * @param ship to be initialized
     * @param player for whom the ship is to be initialized
     */
    void initializeNewShip(IShip ship, IAIPlayer player);
}
