package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * Base strategy for hiring a captain only for ships of a minimal capacity
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 31, 2016
 */
public abstract class BaseHireCaptainForShipAboveSizeStrategy extends BaseHireCaptainStrategy {

    private final int minShipCapacity;

    public BaseHireCaptainForShipAboveSizeStrategy(int minShipCapacity) {
        this.minShipCapacity = minShipCapacity;
    }

    @Override
    public boolean shouldHire(IAIPlayer player, IShip vessel, ICity city) {
        return vessel.getCapacity() >= minShipCapacity;
    }
}
