package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;

/**
 * Strategy to collect wares to construct a holk.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 26, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class CollectConstructionWestCityHolkWareStrategy extends CollectionConstructionWestCityWaresStrategy {
    public CollectConstructionWestCityHolkWareStrategy() {
        super(EShipType.HOLK);
    }

    @Override
    protected IAITradeStrategyType getStrategyType() {
        return ECollectConstructionWareStrategyType.HOMETOWN_HOLK;
    }
}
