package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.sea.DangerService;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivity;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivityEntry;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.player.IAIHireSailorStrategy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Random;

/**
 * Strategy for calculating the sailor amount on ships based on the danger level.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Nov 04, 2017
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class DefaultHireSailorsStrategy implements IAIHireSailorStrategy {
    @Autowired
    private DangerService dangerService;
    @Autowired
    private PirateActivity pirateActivity;
    @Autowired
    private Random rnd;
    @Override
    public int calculateRequiredSailorAmount(IShip ship, IAIPlayer player) {
        int min = ship.getMinNumberOfSailors();
        int max = ship.getMaxNumberOfSailors();
        int range = max - min;
        List<PirateActivityEntry> activity = pirateActivity.getPirateActivity();
        int observationDuration = pirateActivity.getObservationPeriodInDays();
        int nbAttacks = dangerService.getNumberOfPirateAttacks(activity);
        double twoWeeks = observationDuration / 14.0;
        double attacksInTwoWeeks = twoWeeks / nbAttacks;
        if (attacksInTwoWeeks > 1) { // There should be one attack in two weeks
            return min;
        }
        if (attacksInTwoWeeks > 0.5) { // there should be one attack in four weeks / or half an attack in two
            return rnd.nextInt(range) + min;
        }
        return max;
    }
}
