package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.ETradeStrategyPreference;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

import java.util.HashSet;
import java.util.Set;

/**
 * Strategy type for the trade strategy.
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public enum EAITradeStrategyType implements IAITradeStrategyType {
    CHEAP_PRODUCTION(CheapProductionTradeStrategy.class),
    TRADE_ROUTE(TradeRouteTradeStrategy.class, ETradeStrategyPreference.FAST_SHIP),
    DYNAMIC_TRADE_ROUTE(DynamicTradeRouteStrategy.class, ETradeStrategyPreference.FAST_SHIP),
    PRODUCTION_CHAIN(ProductionChainTradeStrategy.class),
    SUPPLY_HOMETOWN(SupplyHometownAIStrategy.class, ETradeStrategyPreference.CONVOY, ETradeStrategyPreference.HOLK),
    COLLECT_WARES_FOR_STORAGE_LOCATION(SupplyCentralTradingStationAIStrategy.class, ETradeStrategyPreference.CONVOY),
    DELIVER_WARES_FROM_CENTRAL_STORAGE(CentralStorageDeliveryTradeStrategy.class, ETradeStrategyPreference.CONVOY),
    COLLECT_WARES(CollectionWaresStrategy.class, ETradeStrategyPreference.FAST_SHIP);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAITradeStrategy> strategyClass;
    private final Set<ETradeStrategyPreference> preferance;

    EAITradeStrategyType(Class<? extends IAITradeStrategy> strategyClass, ETradeStrategyPreference...prefs) {
        this.strategyClass = strategyClass;
        preferance = new HashSet<>();
        for (ETradeStrategyPreference pref : prefs) {
            preferance.add(pref);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAITradeStrategy getStrategy() {
        return context.getBean(strategyClass);
    }


    @Override
    public Set<ETradeStrategyPreference> getStrategyPreferrance() {
        return preferance;
    }
}
