package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import java.util.ArrayList;

/**
 * Base trade step for dumping various wares, instead of selling them.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 24, 2016
 */
@Prototype
public abstract class AbstractAggregateDumpTradeStep implements ITradeStep {
    @Setter
    @Getter
    private INavigableVessel vessel;
    @Setter
    private ICity city;
    @Setter
    private boolean executeNext = true;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;
    @ListType(SellDumpTradeStep.class)
    private ArrayList<SellDumpTradeStep> tradeSteps = new ArrayList<>();

    public void addSellStep(IWare ware) {
        SellDumpTradeStep sellStep = context.getBean(SellDumpTradeStep.class);
        sellStep.setCity(city);
        sellStep.setVessel(vessel);
        sellStep.setWare(ware);
        tradeSteps.add(sellStep);
    }

    @Override
    public boolean execute() {
        Preconditions.checkArgument(vessel.getLocation().equals(city.getCoordinates()), "The vessel is not in city "+city.getName()+" but at "+vessel.getLocation());
        for (SellDumpTradeStep buyTradeStep : tradeSteps) {
            if (vessel.getWare(buyTradeStep.getWare()).getAmount() > 0) {
                buyTradeStep.execute();
            }
        }
        return executeNext;
    }
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        tradeSteps.stream().forEach(step -> sb.append(step.getWare().name()).append(" "));
        return getClass().getSimpleName()+" player "+ ((IPlayer)vessel.getOwner()).getUuid() +" in "+city.getName()+" dumping: "+ sb.toString();
    }
}
