package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Optional;

/**
 * Buy trade step to buy wares and store it in the trading office.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 21, 2016
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class BuyTradingOfficeTradeStep implements ITradeStep {
    @Setter
    @Getter(AccessLevel.PROTECTED)
    private ICity city;
    @Setter
    @Getter
    private ITradingOffice tradingOffice;
    @Setter
    @Getter
    private IWare ware;
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;
    @Setter
    private int maxBuyPrice;
    @Setter
    private long retainCash = 0L;

    @Override
    public boolean execute() {
        IWare ware = getWare();
        IPlayer player = tradingOffice.getOwner();
        int maxAmount = tradingOffice.capacityProperty().get() - tradingOffice.getOccupiedSpace();
        if (!ware.isBarrelSizedWare()) {
            maxAmount /= 10;
        }
        tradeService.buyFromCityToStorage(tradingOffice, player, city, ware, maxAmount, Optional.of(maxBuyPrice), tradingOffice.getSteward(), retainCash);
        return true;
    }

    @Override
    public String toString() {
        return "BuyTradingOfficeTradeStep player "+ tradingOffice.getOwner().getUuid() +" {Buy "
                + getWare() + " in "
                + getCity().getName() + "}";
    }
}
