package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.BuyWeapons;
import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Getter;
import lombok.Setter;

import java.util.Optional;

/**
 * Trade step for buying weapons. Weapons can only be bought for ships not convoys. If the set <code>vessel</code> is
 * a convoy, nothing will be bought.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 19, 2017
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class BuyWeaponTradeStep implements ITradeStep {
    @Setter
    @Getter
    private ICity city;
    @Setter
    @Getter
    private IAIPlayer player;
    @Getter
    @Setter
    private INavigableVessel vessel;

    @Override
    public boolean execute() {
        if (vessel instanceof IShip) {
            IAIBuyWeaponStrategy strategy = player.getWeaponBuyStrategyType().getStrategy();
            IShip ship = (IShip) this.vessel;
            Optional<BuyWeapons> optBuyWeapons = strategy.shouldBuyWeapons(ship, player, city);
            optBuyWeapons.ifPresent(buyWeapons -> strategy.buyWeapons(buyWeapons, ship, player, city));
        }
        return true;
    }

    @Override
    public String toString() {
        return "BuyWeaponTradeStep player "+ player.getUuid() +" {Buy "
                + "Weapons? for "
                + getVessel().getName() + "("
                + getVessel().getUuid() + ") in "
                + getCity().getName() + "}";
    }
}
