package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Optional;

/**
 * Implements the sell step for selling a single ware up to a minimum sell price.
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class SellTradeStep implements ITradeStep {
    @Setter
    private ICity city;
    @Setter
    @Getter
    private IWare ware;
    @Setter
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;

    @Setter
    private boolean executeNext = true;

    @Override
    public boolean execute() {
        int maxSellAmount = vessel.getWare(ware).getAmount();
        int minSellPrice = vessel.getWare(ware).getAVGPrice();
        IAIPlayer player = (IAIPlayer) vessel.getOwner();
        tradeService.sellWareShipToCity(vessel, player, city, ware, maxSellAmount, Optional.of(minSellPrice));
        return executeNext;
    }

    @Override
    public String toString() {
        return "SellTradeStep player "+ ((IPlayer)vessel.getOwner()).getUuid() +" {Sell "
                + getWare() + " for "
                + vessel.getName() + "("
                + vessel.getUuid() + ") in "
                + city.getName() + " for a min price of"
                + vessel.getWare(getWare()).getAVGPrice() + "}";
    }}
