package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Setter;

/**
 * Implements the trade step for taking a loan. How the decission on taking a loan is done
 * is defined by the {@link ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategy} defined
 * on the player. If it is not possible to take a loan nothing happens.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jun 12, 2016
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class TakeLoanTradeStep implements ITradeStep{
    @Setter
    private ICity city;
    @Setter
    private IAIPlayer player;

    @Override
    public boolean execute() {
        IAITakeLoanStrategy strategy = player.getTakeLoanStrategyType().getStrategy();
        if (strategy.shouldTakeLoan(player)) {
            strategy.takeLoan(player, city);
        }
        return true;
    }

    @Override
    public String toString() {
        return "TakeLoanTradeStep "
                +player.getUuid()+" take load in "
                + city.getName();
    }
}
