/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.openpatrician.engine.ClockTickTimer;
import ch.sahits.game.openpatrician.model.initialisation.MapInitializedBean;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ComponentScan
@ClassCategory(value={EClassCategory.STARTUP})
public class EngineConfiguration {
    @Bean
    @Scope(value="prototype")
    public StartNewGameBean startNewGameBean() {
        return new StartNewGameBean();
    }

    @Bean
    @Scope(value="prototype")
    public MapInitializedBean mapInitializedBean() {
        return new MapInitializedBean();
    }

    @Bean
    public ClockTickTimer clockTickTimer() {
        return new ClockTickTimer(100L, -1L);
    }

    @Bean
    public ExecutorService paralleizationExecutor() {
        int threads = Runtime.getRuntime().availableProcessors();
        return Executors.newFixedThreadPool(threads);
    }

    @Bean
    public ScheduledExecutorService schedulableServerThreadPool() {
        int threads = Runtime.getRuntime().availableProcessors();
        return Executors.newScheduledThreadPool(threads / 2 + 1);
    }

    @Bean
    public ScheduledExecutorService serverTimer() {
        int threads = Runtime.getRuntime().availableProcessors();
        return Executors.newScheduledThreadPool(threads / 2 + 1);
    }
}

