/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event;

import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import com.google.common.base.Preconditions;
import java.util.Optional;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class AIPlayerEngineState {
    @OptionalType(value=INavigableVessel.class)
    private Optional<INavigableVessel> currentVesselExecutingTrade = Optional.empty();

    public synchronized void activateVesselForTrade(INavigableVessel vessel) {
        Preconditions.checkArgument((!this.currentVesselExecutingTrade.isPresent() ? 1 : 0) != 0, (Object)"There must not be a previous vessel set.");
        this.currentVesselExecutingTrade = Optional.of(vessel);
    }

    public synchronized void deactivateVesselForTrade(INavigableVessel vessel) {
        Preconditions.checkArgument((boolean)this.currentVesselExecutingTrade.isPresent(), (Object)("There is currently no active vessel to deactivate " + vessel.getName() + " (" + vessel.getUuid() + ")."));
        Preconditions.checkArgument((boolean)this.currentVesselExecutingTrade.get().equals(vessel), (Object)("The vessel to deactivate is currently not active: " + vessel.getName() + " (" + vessel.getUuid() + ")."));
        this.currentVesselExecutingTrade = Optional.empty();
    }

    public synchronized boolean isActive(INavigableVessel vessel) {
        return this.currentVesselExecutingTrade.isPresent() && this.currentVesselExecutingTrade.get().equals(vessel);
    }
}

