/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.data.RepairFinishedEvent;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class RepairTask
extends TimedTask {
    @Autowired
    @XStreamOmitField
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    private final IShip ship;
    protected final ICityPlayerProxyJFX city;
    private final IShipyard shipyard;

    public RepairTask(LocalDateTime executionTime, IShip ship, ICityPlayerProxyJFX city, IShipyard shipyard) {
        this.setExecutionTime(executionTime);
        this.ship = ship;
        this.city = city;
        this.shipyard = shipyard;
    }

    public void run() {
        IShipOwner owner;
        this.ship.repair();
        this.shipyard.removeCompletedRepair(this.ship);
        this.ship.setAvailable(true);
        this.city.getPlayersShips().add((Object)this.ship);
        if (this.city.getPlayersShips().size() == 1) {
            this.city.activateShip((INavigableVessel)this.ship);
        }
        if ((owner = this.ship.getOwner()) instanceof IHumanPlayer) {
            DisplayMessage msg = new DisplayMessage(EMessageCategory.PERSONAL, "ch.sahits.game.openpatrician.engine.event.task.RepairTask.message", new Object[]{this.ship.getName()});
            TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer)owner, (Object)msg);
            this.clientServerEventBus.post((Object)displayMessage);
        } else {
            this.clientServerEventBus.post((Object)new RepairFinishedEvent((INavigableVessel)this.ship));
        }
    }

    public String toString() {
        return "RepairTask{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", ship=" + this.ship.getUuid() + "}";
    }
}

