/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.model.factory.PlayerInteractionFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.CityProductionAndConsumptionService;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CitiesState;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.impl.BalanceSheet;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.spring.DependentAnnotationConfigApplicationContext;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WeeklyCityCheckTask
extends TimedTask {
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    @XStreamOmitField
    private ServerSideTaskFactory taskFactory;
    @Autowired
    private CitiesState citiesState;
    @Autowired
    @XStreamOmitField
    private CityProductionAndConsumptionService productionAndConsumtionService;
    @Autowired
    @XStreamOmitField
    private PlayerInteractionFactory interactionFactory;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;

    @PostConstruct
    private void initialize() {
        this.setExecutionTime(this.getScheduledDateWeeklyUpdate());
    }

    private LocalDateTime getScheduledDateWeeklyUpdate() {
        return this.date.getCurrentDate().plusWeeks(1L);
    }

    public void run() {
        this.handleWeeklyUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWeeklyUpdates() {
        try {
            for (CityState cityState : this.citiesState.getCityEngineStates()) {
                this.productionAndConsumtionService.produceWares(cityState);
                ICity city = cityState.getCity();
                List offices = city.findBuilding(ITradingOffice.class, Optional.empty());
                for (ITradingOffice office : offices) {
                    IBalanceSheet discardableSheet = office.getCurrentWeek();
                    BalanceSheet newWeek = this.interactionFactory.createBalanceSheetFromPreviousWeek((BalanceSheet)discardableSheet);
                    office.replaceBalanceSheet((IBalanceSheet)newWeek);
                    ((DependentAnnotationConfigApplicationContext)this.context).removePrototypeBean((Object)discardableSheet);
                }
            }
        }
        finally {
            this.scheduleNextWeekUpdate();
        }
    }

    private void scheduleNextWeekUpdate() {
        this.taskList.add(this.taskFactory.getWeeklyCityCheck());
    }

    public String toString() {
        return "WeeklyCityCheckTask{UUID=" + this.getUuid() + ", when=" + this.getExecutionTime() + "}";
    }
}

