/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.PeriodicalDailyUpdate;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.people.ContractBrokerConnections;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.people.IContractBrokers;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class ContractBrokers
implements IContractBrokers {
    @ListType(value=ContractBrokerConnections.class)
    private List<ContractBrokerConnections> brokers = new ArrayList<ContractBrokerConnections>();
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private ModelTranslations translationService;
    @Autowired
    @XStreamOmitField
    private DialogTemplateFactory dialogTemplateFactory;

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    public void add(IContractBroker broker, ICity city) {
        long numbers = this.brokers.stream().filter(connection -> connection.getCity().equals(city)).count();
        Preconditions.checkArgument((numbers == 0L ? 1 : 0) != 0, (Object)"There can only be on contract broker be assigned to a city at a time.");
        this.brokers.add(new ContractBrokerConnections(broker, city));
    }

    public void assignPlayer(IPlayer player, IContractBroker broker, LocalDateTime deadline) {
        this.brokers.stream().filter(connection -> connection.getContractBroker().equals(broker)).forEach(connection -> {
            connection.setAssignedPlayer(Optional.of(player));
            connection.setDeadline(deadline);
        });
    }

    public void remove(IContractBroker broker) {
        this.brokers.removeIf(connection -> connection.getContractBroker().equals(broker));
    }

    @Subscribe
    public void removePastDeadline(PeriodicalDailyUpdate event) {
        Iterator<ContractBrokerConnections> iterator = this.brokers.iterator();
        while (iterator.hasNext()) {
            ContractBrokerConnections connection = iterator.next();
            if (connection.getDeadline() == null || !connection.getDeadline().isBefore(event.getDateTime())) continue;
            iterator.remove();
            if (!(connection.getAssignedPlayer().get() instanceof IHumanPlayer)) continue;
            IContractBroker broker = connection.getContractBroker();
            DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{broker.getAmountAndPrice().getAmount(), this.translationService.getLocalDisplayName((IWare)((EWare)broker.getWare())), broker.getName(), connection.getCity().getName(), this.translationService.toDisplayString(connection.getDeadline())});
            DialogTemplate template = this.dialogTemplateFactory.createDialogTemplate(EDialogTemplateType.CONTRACT_BROKER_NO_DELIVERY, parameterSupplier);
            DisplayTemplateMessage message = new DisplayTemplateMessage(EMessageCategory.PERSONAL, "ch.sahits.game.openpatrician.engine.land.city.ContractBrokers.unreliable", template, new Object[0]);
            TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)connection.getAssignedPlayer().get(), (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        }
    }

    public Optional<IContractBroker> findContractBroker(ICity city, IPlayer player) {
        return this.brokers.stream().filter(connection -> connection.getCity().equals(city) && connection.getAssignedPlayer().isPresent() && ((IPlayer)connection.getAssignedPlayer().get()).equals(player)).map(connection -> connection.getContractBroker()).findFirst();
    }

    public boolean hasContractBroker(ICity city) {
        return this.brokers.stream().filter(connection -> connection.getCity().equals(city)).findFirst().isPresent();
    }
}

