/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.event.data.ShipyardOrderBuild;
import ch.sahits.game.openpatrician.event.data.ShipyardOrderRefit;
import ch.sahits.game.openpatrician.event.data.ShipyardOrderRepair;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.IShipDueDate;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.impl.IShipBuildTask;
import ch.sahits.game.openpatrician.model.city.impl.ShipDueDate;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.ship.EShipTravelState;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ShipyardEngine
extends AbstractEngine {
    private static final Logger log = LoggerFactory.getLogger(ShipyardEngine.class);
    @Autowired
    private Date date;
    @Autowired
    private Random rnd;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private ShipFactory shipUtility;
    @Autowired
    private ServerSideTaskFactory taskFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    private LocalDateTime orderShipBuilding(IShipyard shipyard, EShipType type, IPlayer owner) {
        int buildTime = shipyard.calculateBuildTime(type);
        LocalDateTime startDate = this.date.getCurrentDate();
        for (IShipDueDate dueDate : shipyard.getShipBuildingList()) {
            if (!dueDate.getDueDate().isAfter(startDate)) continue;
            startDate = dueDate.getDueDate();
        }
        LocalDateTime finished = startDate.plusDays(buildTime);
        TimedTask task = (TimedTask)this.taskFactory.getShipBuildTask(finished, type, owner, shipyard.getCity().getCoordinates(), shipyard);
        ShipDueDate dueDate = new ShipDueDate(((IShipBuildTask)task).getShipToBeBuilt(), finished);
        shipyard.addShipBuildingOrder((IShipDueDate)dueDate, Optional.of(task));
        this.taskList.add(task);
        return finished;
    }

    private void repair(IShipyard shipyard, IShip ship, ICityPlayerProxyJFX proxy) {
        int repairTime = shipyard.calculateBuildTime(ship.getShipType());
        int damageInv = ship.getDamage();
        repairTime = Math.max((int)((double)repairTime * Math.max((double)damageInv / 100.0, 0.05)), 1);
        LocalDateTime startDate = this.findeLatestDate(shipyard.getShipRepairList());
        ShipDueDate dueDate = new ShipDueDate(ship, startDate.plusDays(repairTime));
        ship.setTravelState(EShipTravelState.REPAIR);
        TimedTask task = this.taskFactory.getRepairTask(dueDate.getDueDate(), ship, proxy, shipyard);
        this.taskList.add(task);
        ship.setAvailable(false);
        shipyard.addShipRepairOrder((IShipDueDate)dueDate, Optional.of(task));
    }

    public void repair(IShipyard shipyard, IShipGroup shipGroup) {
        int repairTime = 0;
        for (IShip ship : shipGroup.getShips()) {
            repairTime += shipyard.calculateRepairTime(ship.getShipType());
            ship.setAvailable(false);
            ship.setTravelState(EShipTravelState.REPAIR);
        }
        int damageInv = shipGroup.getDamage();
        repairTime = Math.max((int)((double)repairTime * Math.max((double)damageInv / 100.0, 0.05)), 1);
        LocalDateTime startDate = this.findeLatestDate(shipyard.getShipRepairList());
        ShipDueDate dueDate = new ShipDueDate((IShip)shipGroup.getShips().get(0), startDate.plusDays(repairTime));
        TimedTask task = this.taskFactory.getPirateRepairTask(dueDate.getDueDate(), (INavigableVessel)shipGroup, (ISeaPirate)shipGroup.getOwner(), shipyard);
        this.taskList.add(task);
        shipyard.addShipRepairOrder((IShipDueDate)dueDate, Optional.of(task));
    }

    public void repairPirateShip(IShipyard shipyard, IShip ship) {
        int repairTime = shipyard.calculateRepairTime(ship.getShipType());
        ship.setAvailable(false);
        int damageInv = ship.getDamage();
        repairTime = Math.max((int)((double)repairTime * Math.max((double)damageInv / 100.0, 0.05)), 1);
        LocalDateTime startDate = this.findeLatestDate(shipyard.getShipRepairList());
        ShipDueDate dueDate = new ShipDueDate(ship, startDate.plusDays(repairTime));
        TimedTask task = this.taskFactory.getPirateRepairTask(dueDate.getDueDate(), (INavigableVessel)ship, (ISeaPirate)ship.getOwner(), shipyard);
        this.taskList.add(task);
        shipyard.addShipRepairOrder((IShipDueDate)dueDate, Optional.of(task));
    }

    public void repairAIShip(IShipyard shipyard, IShip ship) {
        int repairTime = shipyard.calculateRepairTime(ship.getShipType());
        ship.setAvailable(false);
        int damageInv = ship.getDamage();
        repairTime = Math.max((int)((double)repairTime * Math.max((double)damageInv / 100.0, 0.05)), 1);
        LocalDateTime startDate = this.findeLatestDate(shipyard.getShipRepairList());
        ShipDueDate dueDate = new ShipDueDate(ship, startDate.plusDays(repairTime));
        ship.setTravelState(EShipTravelState.REPAIR);
        TimedTask task = this.taskFactory.getAIShipRepairTask(dueDate.getDueDate(), ship, shipyard);
        this.taskList.add(task);
        shipyard.addShipRepairOrder((IShipDueDate)dueDate, Optional.of(task));
    }

    public void refitAIShip(IShipyard shipyard, IShip ship) {
        int refitTime = shipyard.calculateRefitTime(ship.getShipType());
        int indexStartLevel = 0;
        EShipUpgrade level = ship.getShipUpgradeLevel();
        EShipUpgrade upgradeLevel = level.nextLevel();
        int indexFinalLevel = 0;
        for (int i = 0; i < EShipUpgrade.values().length; ++i) {
            if (EShipUpgrade.values()[i] == level) {
                indexStartLevel = i;
            }
            if (EShipUpgrade.values()[i] != upgradeLevel) continue;
            indexFinalLevel = i;
            break;
        }
        int nbLevelUpgrades = Math.max(indexFinalLevel - indexStartLevel, 0);
        LocalDateTime startDate = this.findeLatestDate(shipyard.getShipUpgradeList());
        ShipDueDate dueDate = new ShipDueDate(ship, startDate.plusDays(refitTime * nbLevelUpgrades));
        ship.setTravelState(EShipTravelState.REPAIR);
        TimedTask task = this.taskFactory.getAIShipRefitTask(dueDate.getDueDate(), ship, upgradeLevel, shipyard);
        this.taskList.add(task);
        ship.setAvailable(false);
        shipyard.addShipRefitOrder((IShipDueDate)dueDate, Optional.of(task));
    }

    private void refit(IShipyard shipyard, IShip ship, EShipUpgrade upgradeLevel, ICityPlayerProxyJFX proxy) {
        int refitTime = shipyard.calculateRefitTime(ship.getShipType());
        EShipUpgrade level = ship.getShipUpgradeLevel();
        int indexStartLevel = 0;
        int indexFinalLevel = 0;
        for (int i = 0; i < EShipUpgrade.values().length; ++i) {
            if (EShipUpgrade.values()[i] == level) {
                indexStartLevel = i;
            }
            if (EShipUpgrade.values()[i] != upgradeLevel) continue;
            indexFinalLevel = i;
            break;
        }
        int nbLevelUpgrades = Math.max(indexFinalLevel - indexStartLevel, 0);
        LocalDateTime startDate = this.findeLatestDate(shipyard.getShipUpgradeList());
        ShipDueDate dueDate = new ShipDueDate(ship, startDate.plusDays(refitTime * nbLevelUpgrades));
        ship.setTravelState(EShipTravelState.REPAIR);
        TimedTask task = this.taskFactory.getRefitShipTask(dueDate.getDueDate(), ship, upgradeLevel, proxy, shipyard);
        this.taskList.add(task);
        ship.setAvailable(false);
        shipyard.addShipRefitOrder((IShipDueDate)dueDate, Optional.of(task));
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Lists.newArrayList();
    }

    @Subscribe
    public void handleOrderBuildEvent(ShipyardOrderBuild event) {
        this.orderShipBuilding(event.getShipyard(), event.getShipType(), event.getOwner());
    }

    @Subscribe
    public void handleOrderRepair(ShipyardOrderRepair event) {
        this.repair(event.getShipyard(), event.getShip(), event.getProxy());
    }

    @Subscribe
    public void handleORderRefit(ShipyardOrderRefit event) {
        this.refit(event.getShipyard(), event.getShip(), event.getUpgradeLevel(), event.getProxy());
    }

    @VisibleForTesting
    LocalDateTime findeLatestDate(List<IShipDueDate> dueDates) {
        LocalDateTime currentDate = this.date.getCurrentDate();
        if (dueDates.isEmpty()) {
            return currentDate;
        }
        LocalDateTime latest = dueDates.get(0).getDueDate();
        if (latest.isBefore(currentDate)) {
            latest = currentDate;
        }
        for (IShipDueDate dueDate : dueDates) {
            if (!dueDate.getDueDate().isAfter(latest)) continue;
            latest = dueDate.getDueDate();
        }
        return latest;
    }
}

