/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.engine.player.ETradeReason;
import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageStrategyHint;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.building.ETradeType;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.building.impl.Steward;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.product.ProductionChain;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TradeManagerService {
    @Autowired
    private ProductionChain productionChain;
    @Autowired
    private PopulationConsume consume;
    @Autowired
    private TradeService tradeService;

    public void hireSteward(ITradingOffice tradingOffice) {
        Preconditions.checkArgument((!tradingOffice.getSteward().isPresent() ? 1 : 0) != 0, (Object)"No steward has to be present");
        tradingOffice.setSteward((ISteward)new Steward());
    }

    public void setupOrUpdateAutomaticTrading(ITradingOffice office) {
        Preconditions.checkArgument((boolean)office.getSteward().isPresent(), (Object)"Steward has to be present");
        IAutomatedTrading autoTrading = office.getOfficeTrading();
        IAIPlayer player = (IAIPlayer)office.getOwner();
        ICity city = office.getCity();
        List workShops = player.findBuildings(city, IWorkShop.class);
        Multimap<IWare, ETradeReason> reasons = this.collectTradeReasons(workShops, city);
        Map<IWare, ETradeReason> definiteReasons = this.condense(reasons);
        List<Object[]> dertmineLimits = this.determineLimits(definiteReasons, city, player, workShops);
        for (EWare ware : EWare.values()) {
            autoTrading.setTradingType((IWare)ware, ETradeType.NONE);
        }
        for (Object[] entry : dertmineLimits) {
            IWare ware = (IWare)entry[0];
            if (definiteReasons.get(ware).isBuyReason()) {
                autoTrading.setTradingType(ware, ETradeType.CITY_OFFICE);
                if (definiteReasons.get(ware) == ETradeReason.PRODUCED_WARE_IN_CITY) {
                    autoTrading.setMovableToShip(ware, true);
                } else {
                    autoTrading.setMovableToShip(ware, false);
                }
            } else {
                autoTrading.setTradingType(ware, ETradeType.OFFICE_CITY);
                autoTrading.setMovableToShip(ware, true);
            }
            autoTrading.amountProperty(ware).setValue((Number)((Integer)entry[1]));
            autoTrading.priceProperty(ware).setValue((Number)((Integer)entry[2]));
        }
    }

    private List<Object[]> determineLimits(Map<IWare, ETradeReason> definiteReasons, ICity city, IAIPlayer player, List<IWorkShop> workShops) {
        ITradingOffice office = (ITradingOffice)player.findTradingOffice(city).get();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (IWare ware : definiteReasons.keySet()) {
            Object[] entry = new Object[3];
            entry[0] = ware;
            ETradeReason tradeReason = definiteReasons.get(ware);
            if (tradeReason.isBuyReason()) {
                entry[1] = this.calculateBuyAmount(ware, city, player, tradeReason, workShops);
                int avgPrice = office.getWare(ware).getAVGPrice();
                entry[2] = Math.min(avgPrice, ware.getMaxBuyPriceModerate());
            } else {
                entry[1] = this.calculateSellAmount(ware, city, player, tradeReason, workShops);
                entry[2] = ware.getMinSellPriceModerate();
            }
            list.add(entry);
        }
        return list;
    }

    @VisibleForTesting
    int calculateSellAmount(IWare ware, ICity city, IAIPlayer player, ETradeReason tradeReason, List<IWorkShop> workShops) {
        switch (tradeReason) {
            case PRODUCED_WARE_IN_WORKSHOP: {
                if (this.hasCentralStorageStrategy(city, player)) {
                    if (this.tradeService.getBasicNeeds().contains(ware)) {
                        return this.calculateCityNeeds(ware, city);
                    }
                    return (int)((double)workShops.stream().filter(workshop -> this.productionChain.getRequiredAmount(workshop.getProducableWare(), ware) > 0.0).mapToInt(workshop -> (int)Math.ceil(this.productionChain.getRequiredAmount(workshop.getProducableWare(), ware))).sum() * 0.5);
                }
                return 0;
            }
            case REQUIRE_FOR_BASIC_NEEDS: {
                if (this.hasCentralStorageStrategy(city, player)) {
                    return (int)((double)this.calculateCityNeeds(ware, city) * 0.5);
                }
                return 0;
            }
            case REQUIRE_FOR_CITY_PRODUCTION: {
                return workShops.stream().filter(workshop -> this.productionChain.getRequiredAmount(workshop.getProducableWare(), ware) > 0.0).mapToInt(workshop -> (int)Math.ceil(this.productionChain.getRequiredAmount(workshop.getProducableWare(), ware))).sum();
            }
        }
        throw new IllegalStateException("Unhandled sell trade reason: " + tradeReason);
    }

    private int calculateCityNeeds(IWare ware, ICity city) {
        int sum = 0;
        for (EPopulationClass popClass : EPopulationClass.values()) {
            sum = (int)((double)sum + this.consume.getNeed(ware, popClass, city.getPopulation(popClass)));
        }
        return sum;
    }

    @VisibleForTesting
    int calculateBuyAmount(IWare ware, ICity city, IAIPlayer player, ETradeReason tradeReason, List<IWorkShop> workShops) {
        switch (tradeReason) {
            case REQUIRE_FOR_PRODUCTION: {
                return workShops.stream().filter(workshop -> this.productionChain.getRequiredWares(workshop.getProducableWare()).contains(ware)).mapToInt(workshop -> (int)Math.ceil(this.productionChain.getRequiredAmount(workshop.getProducableWare(), ware))).sum();
            }
            case PRODUCED_WARE_IN_CITY: {
                int baseAmount = ware.isBarrelSizedWare() ? 20 : 5;
                if (this.tradeService.getBasicNeeds().contains(ware) && (this.hasCentralStorageStrategy(city, player) || this.playerProduces(city, player, ware))) {
                    baseAmount *= 2;
                }
                return baseAmount;
            }
        }
        throw new IllegalStateException("Unhandled buy trade reason: " + tradeReason);
    }

    private boolean hasCentralStorageStrategy(ICity city, IAIPlayer player) {
        return player.getPlayerContext().getHints(city).stream().filter(hint -> hint instanceof CentralStorageStrategyHint).findFirst().isPresent();
    }

    public boolean playerProduces(ICity city, IAIPlayer player, IWare ware) {
        return player.findBuildings(city, IWorkShop.class).stream().filter(workshop -> workshop.getProducableWare().equals(ware)).findFirst().isPresent();
    }

    @VisibleForTesting
    Map<IWare, ETradeReason> condense(Multimap<IWare, ETradeReason> reasons) {
        HashMap<IWare, ETradeReason> condensation = new HashMap<IWare, ETradeReason>();
        for (IWare ware : reasons.keySet()) {
            List sellReasons;
            Collection reasonCol = reasons.get((Object)ware);
            if (reasonCol.size() == 1) {
                condensation.put(ware, (ETradeReason)((Object)reasonCol.iterator().next()));
                continue;
            }
            ETradeReason mainReason = null;
            List buyReasons = reasonCol.stream().filter(ETradeReason::isBuyReason).collect(Collectors.toList());
            if (!buyReasons.isEmpty()) {
                buyReasons.sort(ETradeReason.comparator());
                mainReason = (ETradeReason)((Object)buyReasons.get(0));
            }
            if (mainReason == null && !(sellReasons = reasonCol.stream().filter(((Predicate<ETradeReason>)ETradeReason::isBuyReason).negate()).collect(Collectors.toList())).isEmpty()) {
                sellReasons.sort(ETradeReason.comparator());
                mainReason = (ETradeReason)((Object)sellReasons.get(0));
            }
            if (mainReason == null) continue;
            condensation.put(ware, mainReason);
        }
        return condensation;
    }

    @VisibleForTesting
    Multimap<IWare, ETradeReason> collectTradeReasons(List<IWorkShop> workShops, ICity city) {
        List requiredWares;
        ArrayListMultimap map = ArrayListMultimap.create();
        for (IWorkShop workShop : workShops) {
            map.put((Object)workShop.getProducableWare(), (Object)ETradeReason.PRODUCED_WARE_IN_WORKSHOP);
            List requiredWares2 = this.productionChain.getRequiredWares(workShop.getProducableWare());
            requiredWares2.stream().forEach(arg_0 -> TradeManagerService.lambda$collectTradeReasons$8((Multimap)map, arg_0));
        }
        for (IWare ware : city.getEffectiveProduction()) {
            map.put((Object)ware, (Object)ETradeReason.PRODUCED_WARE_IN_CITY);
            requiredWares = this.productionChain.getRequiredWares(ware);
            requiredWares.stream().forEach(arg_0 -> TradeManagerService.lambda$collectTradeReasons$9((Multimap)map, arg_0));
        }
        for (IWare ware : city.getIneffectiveProduction()) {
            map.put((Object)ware, (Object)ETradeReason.PRODUCED_WARE_IN_CITY);
            requiredWares = this.productionChain.getRequiredWares(ware);
            requiredWares.stream().forEach(arg_0 -> TradeManagerService.lambda$collectTradeReasons$10((Multimap)map, arg_0));
        }
        this.tradeService.getBasicNeeds().stream().forEach(arg_0 -> TradeManagerService.lambda$collectTradeReasons$11((Multimap)map, arg_0));
        return map;
    }

    private static /* synthetic */ void lambda$collectTradeReasons$11(Multimap map, IWare ware) {
        map.put((Object)ware, (Object)ETradeReason.REQUIRE_FOR_BASIC_NEEDS);
    }

    private static /* synthetic */ void lambda$collectTradeReasons$10(Multimap map, IWare reqWare) {
        map.put((Object)reqWare, (Object)ETradeReason.REQUIRE_FOR_CITY_PRODUCTION);
    }

    private static /* synthetic */ void lambda$collectTradeReasons$9(Multimap map, IWare reqWare) {
        map.put((Object)reqWare, (Object)ETradeReason.REQUIRE_FOR_CITY_PRODUCTION);
    }

    private static /* synthetic */ void lambda$collectTradeReasons$8(Multimap map, IWare ware) {
        map.put((Object)ware, (Object)ETradeReason.REQUIRE_FOR_PRODUCTION);
    }
}

